/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import com.google.common.annotations.VisibleForTesting;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.peripheral.monitor.BlockMonitor;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.Expander;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.monitor.MonitorPeripheral;
import dan200.computercraft.shared.peripheral.monitor.MonitorState;
import dan200.computercraft.shared.peripheral.monitor.MonitorWatcher;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import dan200.computercraft.shared.peripheral.monitor.XYPair;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileMonitor
extends TileGeneric {
    public static final double RENDER_BORDER = 0.125;
    public static final double RENDER_MARGIN = 0.03125;
    public static final double RENDER_PIXEL_SCALE = 0.015625;
    private static final String NBT_X = "XIndex";
    private static final String NBT_Y = "YIndex";
    private static final String NBT_WIDTH = "Width";
    private static final String NBT_HEIGHT = "Height";
    private final boolean advanced;
    private ServerMonitor serverMonitor;
    private ClientMonitor clientMonitor;
    private MonitorPeripheral peripheral;
    private LazyOptional<IPeripheral> peripheralCap;
    private final Set<IComputerAccess> computers = new HashSet<IComputerAccess>();
    private boolean needsUpdate = false;
    private boolean needsValidating = false;
    private boolean destroyed = false;
    boolean enqueued;
    TerminalState cached;
    private int width = 1;
    private int height = 1;
    private int xIndex = 0;
    private int yIndex = 0;
    private BlockPos bbPos;
    private BlockState bbState;
    private int bbX;
    private int bbY;
    private int bbWidth;
    private int bbHeight;
    private AABB boundingBox;
    TickScheduler.Token tickToken = new TickScheduler.Token(this);

    public TileMonitor(BlockEntityType<? extends TileMonitor> type, BlockPos pos, BlockState state, boolean advanced) {
        super(type, pos, state);
        this.advanced = advanced;
    }

    public void m_6339_() {
        super.m_6339_();
        this.needsValidating = true;
        TickScheduler.schedule(this.tickToken);
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (!this.m_58904_().f_46443_) {
            this.contractNeighbours();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.clientMonitor != null && this.xIndex == 0 && this.yIndex == 0) {
            this.clientMonitor.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.clientMonitor != null && this.xIndex == 0 && this.yIndex == 0) {
            this.clientMonitor.destroy();
        }
    }

    @Override
    @Nonnull
    public InteractionResult onActivate(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_6047_() && this.getFront() == hit.m_82434_()) {
            if (!this.m_58904_().f_46443_) {
                this.monitorTouched((float)(hit.m_82450_().f_82479_ - (double)hit.m_82425_().m_123341_()), (float)(hit.m_82450_().f_82480_ - (double)hit.m_82425_().m_123342_()), (float)(hit.m_82450_().f_82481_ - (double)hit.m_82425_().m_123343_()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128405_(NBT_X, this.xIndex);
        tag.m_128405_(NBT_Y, this.yIndex);
        tag.m_128405_(NBT_WIDTH, this.width);
        tag.m_128405_(NBT_HEIGHT, this.height);
        super.m_183515_(tag);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.xIndex = nbt.m_128451_(NBT_X);
        this.yIndex = nbt.m_128451_(NBT_Y);
        this.width = nbt.m_128451_(NBT_WIDTH);
        this.height = nbt.m_128451_(NBT_HEIGHT);
    }

    @Override
    public void blockTick() {
        if (this.needsValidating) {
            this.needsValidating = false;
            this.validate();
        }
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.expand();
        }
        if (this.xIndex != 0 || this.yIndex != 0 || this.serverMonitor == null) {
            return;
        }
        if (this.serverMonitor.pollResized()) {
            this.eachComputer(c -> c.queueEvent("monitor_resize", c.getAttachmentName()));
        }
        if (this.serverMonitor.pollTerminalChanged()) {
            MonitorWatcher.enqueue(this);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.peripheralCap = CapabilityUtil.invalidate(this.peripheralCap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            this.createServerMonitor();
            if (this.peripheral == null) {
                this.peripheral = new MonitorPeripheral(this);
            }
            if (this.peripheralCap == null) {
                this.peripheralCap = LazyOptional.of(() -> this.peripheral);
            }
            return this.peripheralCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    @VisibleForTesting
    public ServerMonitor getCachedServerMonitor() {
        return this.serverMonitor;
    }

    @Nullable
    private ServerMonitor getServerMonitor() {
        if (this.serverMonitor != null) {
            return this.serverMonitor;
        }
        TileMonitor origin = this.getOrigin().getMonitor();
        if (origin == null) {
            return null;
        }
        this.serverMonitor = origin.serverMonitor;
        return this.serverMonitor;
    }

    @Nullable
    private ServerMonitor createServerMonitor() {
        if (this.serverMonitor != null) {
            return this.serverMonitor;
        }
        if (this.xIndex == 0 && this.yIndex == 0) {
            this.serverMonitor = new ServerMonitor(this.advanced, this);
            this.serverMonitor.rebuild();
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    TileMonitor monitor = this.getLoadedMonitor(x, y).getMonitor();
                    if (monitor == null) continue;
                    monitor.serverMonitor = this.serverMonitor;
                }
            }
            return this.serverMonitor;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.toWorldPos(0, 0));
        if (!(te instanceof TileMonitor)) {
            return null;
        }
        TileMonitor monitor = (TileMonitor)te;
        this.serverMonitor = monitor.createServerMonitor();
        return this.serverMonitor;
    }

    @Nullable
    public ClientMonitor getClientMonitor() {
        if (this.clientMonitor != null) {
            return this.clientMonitor;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.toWorldPos(0, 0));
        if (!(te instanceof TileMonitor)) {
            return null;
        }
        TileMonitor monitor = (TileMonitor)te;
        this.clientMonitor = monitor.clientMonitor;
        return this.clientMonitor;
    }

    @Nonnull
    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public final CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_(NBT_X, this.xIndex);
        nbt.m_128405_(NBT_Y, this.yIndex);
        nbt.m_128405_(NBT_WIDTH, this.width);
        nbt.m_128405_(NBT_HEIGHT, this.height);
        return nbt;
    }

    @Override
    public final void handleUpdateTag(@Nonnull CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        int oldXIndex = this.xIndex;
        int oldYIndex = this.yIndex;
        this.xIndex = nbt.m_128451_(NBT_X);
        this.yIndex = nbt.m_128451_(NBT_Y);
        this.width = nbt.m_128451_(NBT_WIDTH);
        this.height = nbt.m_128451_(NBT_HEIGHT);
        if (oldXIndex != this.xIndex || oldYIndex != this.yIndex) {
            if (oldXIndex == 0 && oldYIndex == 0 && this.clientMonitor != null) {
                this.clientMonitor.destroy();
            }
            this.clientMonitor = null;
        }
        if (this.xIndex == 0 && this.yIndex == 0 && this.clientMonitor == null) {
            this.clientMonitor = new ClientMonitor(this);
        }
    }

    public final void read(TerminalState state) {
        if (this.xIndex != 0 || this.yIndex != 0) {
            ComputerCraft.log.warn("Receiving monitor state for non-origin terminal at {}", (Object)this.m_58899_());
            return;
        }
        if (this.clientMonitor == null) {
            this.clientMonitor = new ClientMonitor(this);
        }
        this.clientMonitor.read(state);
    }

    private void updateBlockState() {
        this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(BlockMonitor.STATE, (Comparable)((Object)MonitorEdgeState.fromConnections(this.yIndex < this.height - 1, this.yIndex > 0, this.xIndex > 0, this.xIndex < this.width - 1))), 2);
    }

    public Direction getDirection() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)BlockMonitor.FACING) ? (Direction)state.m_61143_((Property)BlockMonitor.FACING) : Direction.NORTH;
    }

    public Direction getOrientation() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)BlockMonitor.ORIENTATION) ? (Direction)state.m_61143_((Property)BlockMonitor.ORIENTATION) : Direction.NORTH;
    }

    public Direction getFront() {
        Direction orientation = this.getOrientation();
        return orientation == Direction.NORTH ? this.getDirection() : orientation;
    }

    public Direction getRight() {
        return this.getDirection().m_122428_();
    }

    public Direction getDown() {
        Direction orientation = this.getOrientation();
        if (orientation == Direction.NORTH) {
            return Direction.UP;
        }
        return orientation == Direction.DOWN ? this.getDirection() : this.getDirection().m_122424_();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    boolean isCompatible(TileMonitor other) {
        return !other.destroyed && this.advanced == other.advanced && this.getOrientation() == other.getOrientation() && this.getDirection() == other.getDirection();
    }

    @Nonnull
    private MonitorState getLoadedMonitor(int x, int y) {
        if (x == this.xIndex && y == this.yIndex) {
            return MonitorState.present(this);
        }
        BlockPos pos = this.toWorldPos(x, y);
        Level world = this.m_58904_();
        if (world == null || !world.m_46749_(pos)) {
            return MonitorState.UNLOADED;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof TileMonitor)) {
            return MonitorState.MISSING;
        }
        TileMonitor monitor = (TileMonitor)tile;
        return this.isCompatible(monitor) ? MonitorState.present(monitor) : MonitorState.MISSING;
    }

    private MonitorState getOrigin() {
        return this.getLoadedMonitor(0, 0);
    }

    BlockPos toWorldPos(int x, int y) {
        if (this.xIndex == x && this.yIndex == y) {
            return this.m_58899_();
        }
        return this.m_58899_().m_5484_(this.getRight(), -this.xIndex + x).m_5484_(this.getDown(), -this.yIndex + y);
    }

    void resize(int width, int height) {
        if (this.xIndex != 0 || this.yIndex != 0) {
            this.serverMonitor = null;
        }
        this.xIndex = 0;
        this.yIndex = 0;
        this.width = width;
        this.height = height;
        boolean needsTerminal = false;
        block0: for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                TileMonitor monitor = this.getLoadedMonitor(x, y).getMonitor();
                if (monitor == null || monitor.peripheral == null) continue;
                needsTerminal = true;
                break block0;
            }
        }
        if (needsTerminal) {
            if (this.serverMonitor == null) {
                this.serverMonitor = new ServerMonitor(this.advanced, this);
            }
        } else {
            this.serverMonitor = null;
        }
        if (this.serverMonitor != null) {
            this.serverMonitor.rebuild();
        }
        BlockPos pos = this.m_58899_();
        Direction down = this.getDown();
        Direction right = this.getRight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                TileMonitor monitor;
                BlockEntity other = this.m_58904_().m_7702_(pos.m_5484_(right, x).m_5484_(down, y));
                if (!(other instanceof TileMonitor) || !this.isCompatible(monitor = (TileMonitor)other)) continue;
                monitor.xIndex = x;
                monitor.yIndex = y;
                monitor.width = width;
                monitor.height = height;
                monitor.serverMonitor = this.serverMonitor;
                monitor.needsValidating = false;
                monitor.needsUpdate = false;
                monitor.updateBlockState();
                monitor.updateBlock();
            }
        }
    }

    void updateNeighborsDeferred() {
        this.needsUpdate = true;
    }

    void expand() {
        TileMonitor monitor = this.getOrigin().getMonitor();
        if (monitor != null && monitor.xIndex == 0 && monitor.yIndex == 0) {
            new Expander(monitor).expand();
        }
    }

    private void contractNeighbours() {
        if (this.width == 1 && this.height == 1) {
            return;
        }
        BlockPos pos = this.m_58899_();
        Direction down = this.getDown();
        Direction right = this.getRight();
        BlockPos origin = this.toWorldPos(0, 0);
        TileMonitor toLeft = null;
        TileMonitor toAbove = null;
        TileMonitor toRight = null;
        TileMonitor toBelow = null;
        if (this.xIndex > 0) {
            toLeft = this.tryResizeAt(pos.m_5484_(right, -this.xIndex), this.xIndex, 1);
        }
        if (this.yIndex > 0) {
            toAbove = this.tryResizeAt(origin, this.width, this.yIndex);
        }
        if (this.xIndex < this.width - 1) {
            toRight = this.tryResizeAt(pos.m_5484_(right, 1), this.width - this.xIndex - 1, 1);
        }
        if (this.yIndex < this.height - 1) {
            toBelow = this.tryResizeAt(origin.m_5484_(down, this.yIndex + 1), this.width, this.height - this.yIndex - 1);
        }
        if (toLeft != null) {
            toLeft.expand();
        }
        if (toAbove != null) {
            toAbove.expand();
        }
        if (toRight != null) {
            toRight.expand();
        }
        if (toBelow != null) {
            toBelow.expand();
        }
    }

    @Nullable
    private TileMonitor tryResizeAt(BlockPos pos, int width, int height) {
        TileMonitor monitor;
        BlockEntity tile = this.f_58857_.m_7702_(pos);
        if (tile instanceof TileMonitor && this.isCompatible(monitor = (TileMonitor)tile)) {
            monitor.resize(width, height);
            return monitor;
        }
        return null;
    }

    private boolean checkMonitorAt(int xIndex, int yIndex) {
        MonitorState state = this.getLoadedMonitor(xIndex, yIndex);
        if (state.isMissing()) {
            return false;
        }
        TileMonitor monitor = state.getMonitor();
        if (monitor == null) {
            return true;
        }
        return monitor.xIndex == xIndex && monitor.yIndex == yIndex && monitor.width == this.width && monitor.height == this.height;
    }

    private void validate() {
        if (this.xIndex == 0 && this.yIndex == 0 && this.width == 1 && this.height == 1) {
            return;
        }
        if (this.xIndex >= 0 && this.xIndex <= this.width && this.width > 0 && this.width <= ComputerCraft.monitorWidth && this.yIndex >= 0 && this.yIndex <= this.height && this.height > 0 && this.height <= ComputerCraft.monitorHeight && this.checkMonitorAt(0, 0) && this.checkMonitorAt(0, this.height - 1) && this.checkMonitorAt(this.width - 1, 0) && this.checkMonitorAt(this.width - 1, this.height - 1)) {
            return;
        }
        ComputerCraft.log.warn("Monitor is malformed, resetting to 1x1.");
        this.resize(1, 1);
        this.needsUpdate = true;
    }

    private void monitorTouched(float xPos, float yPos, float zPos) {
        if (!this.advanced) {
            return;
        }
        XYPair pair = XYPair.of(xPos, yPos, zPos, this.getDirection(), this.getOrientation()).add(this.xIndex, this.height - this.yIndex - 1);
        if ((double)pair.x() > (double)this.width - 0.125 || (double)pair.y() > (double)this.height - 0.125 || (double)pair.x() < 0.125 || (double)pair.y() < 0.125) {
            return;
        }
        ServerMonitor serverTerminal = this.getServerMonitor();
        if (serverTerminal == null) {
            return;
        }
        NetworkedTerminal originTerminal = serverTerminal.getTerminal();
        if (originTerminal == null) {
            return;
        }
        double xCharWidth = ((double)this.width - 0.3125) / (double)originTerminal.getWidth();
        double yCharHeight = ((double)this.height - 0.3125) / (double)originTerminal.getHeight();
        int xCharPos = (int)Math.min((double)originTerminal.getWidth(), Math.max(((double)pair.x() - 0.125 - 0.03125) / xCharWidth + 1.0, 1.0));
        int yCharPos = (int)Math.min((double)originTerminal.getHeight(), Math.max(((double)pair.y() - 0.125 - 0.03125) / yCharHeight + 1.0, 1.0));
        this.eachComputer(c -> c.queueEvent("monitor_touch", c.getAttachmentName(), xCharPos, yCharPos));
    }

    private void eachComputer(Consumer<IComputerAccess> fun) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                TileMonitor monitor = this.getLoadedMonitor(x, y).getMonitor();
                if (monitor == null) continue;
                for (IComputerAccess computer : monitor.computers) {
                    fun.accept(computer);
                }
            }
        }
    }

    void addComputer(IComputerAccess computer) {
        this.computers.add(computer);
    }

    void removeComputer(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Nonnull
    public AABB getRenderBoundingBox() {
        if (this.boundingBox != null && this.m_58900_().equals(this.bbState) && this.m_58899_().equals((Object)this.bbPos) && this.xIndex == this.bbX && this.yIndex == this.bbY && this.width == this.bbWidth && this.height == this.bbHeight) {
            return this.boundingBox;
        }
        this.bbState = this.m_58900_();
        this.bbPos = this.m_58899_();
        this.bbX = this.xIndex;
        this.bbY = this.yIndex;
        this.bbWidth = this.width;
        this.bbHeight = this.height;
        BlockPos startPos = this.toWorldPos(0, 0);
        BlockPos endPos = this.toWorldPos(this.width, this.height);
        this.boundingBox = new AABB((double)Math.min(startPos.m_123341_(), endPos.m_123341_()), (double)Math.min(startPos.m_123342_(), endPos.m_123342_()), (double)Math.min(startPos.m_123343_(), endPos.m_123343_()), (double)(Math.max(startPos.m_123341_(), endPos.m_123341_()) + 1), (double)(Math.max(startPos.m_123342_(), endPos.m_123342_()) + 1), (double)(Math.max(startPos.m_123343_(), endPos.m_123343_()) + 1));
        return this.boundingBox;
    }
}

