/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.entity;

import cofh.core.client.particle.options.CylindricalParticleOptions;
import cofh.core.init.CoreEntities;
import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import cofh.core.util.AreaUtils;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.entity.AbstractAoESpell;
import cofh.lib.util.helpers.MathHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Shockwave
extends AbstractAoESpell {
    public static final float speed = 1.0f;
    public float power;
    public int debuffDuration = 100;

    public Shockwave(EntityType<? extends Shockwave> type, Level world) {
        super((EntityType<? extends AbstractAoESpell>)type, world);
        this.radius = 8.0f;
        this.duration = MathHelper.ceil(this.radius / 1.0f);
    }

    public Shockwave(Level world, LivingEntity attacker, Vec3 pos, float power) {
        this((EntityType<? extends Shockwave>)((EntityType)CoreEntities.SHOCKWAVE.get()), world);
        this.owner = attacker;
        this.m_6034_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        this.power = power;
    }

    @Override
    public void onCast() {
        if (this.f_19853_.f_46443_) {
            BlockPos pos = this.m_20183_();
            this.f_19853_.m_7106_((ParticleOptions)new CylindricalParticleOptions((ParticleType<? extends CylindricalParticleOptions>)((ParticleType)CoreParticles.SHOCKWAVE.get()), this.radius * 2.0f, (float)(this.duration + 5), 0.6f), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void activeTick() {
        if (this.f_19853_.m_5776_()) {
            BlockPos center = this.m_20183_();
            VFXHelper.SHOCKWAVE_OFFSETS.subMap(Float.valueOf(Math.min((float)this.f_19797_ * 1.0f, this.radius)), Float.valueOf(Math.min((float)(this.f_19797_ + 1) * 1.0f, this.radius))).values().forEach(offs -> offs.forEach(off -> {
                if (this.f_19853_.m_213780_().m_188499_()) {
                    for (int y = 1; y >= -1; --y) {
                        BlockPos pos = center.m_121955_((Vec3i)off.apply(y));
                        BlockState state = this.f_19853_.m_8055_(pos);
                        if (state.m_60795_() || !state.m_60796_((BlockGetter)this.f_19853_, pos) || !state.m_60838_((BlockGetter)this.f_19853_, pos) || state.m_155947_() || this.f_19853_.m_8055_(pos.m_7494_()).m_60838_((BlockGetter)this.f_19853_, pos.m_7494_())) continue;
                        this.f_19853_.m_142052_(pos, state);
                        return;
                    }
                }
            }));
        } else {
            this.attack();
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean attack() {
        boolean hitSomething = false;
        float dist = (float)this.f_19797_ * 1.0f;
        float r = 0.75f;
        float r2 = r * r;
        float strength = this.power * ((float)this.duration - (float)this.f_19797_ * 0.5f) / (float)this.duration;
        float damage = strength * 8.0f;
        Vec3 pos = this.m_20182_();
        for (LivingEntity entity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82377_((double)(dist + r), 2.0, (double)(dist + r)), EntitySelector.f_20406_)) {
            DamageSource source;
            DamageSource damageSource;
            if (entity.equals((Object)this.owner)) continue;
            Vec3 relPos = entity.m_20182_().m_82546_(pos);
            Vec3 center = new Vec3(relPos.f_82479_, 0.0, relPos.f_82481_).m_82541_().m_82490_((double)dist).m_82549_(pos);
            if (AreaUtils.closestPointOnAABB(center, entity.m_20191_()).m_82546_(center).m_165925_() > (double)r2) continue;
            LivingEntity livingEntity = this.owner;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                damageSource = DamageSource.m_19344_((Player)player);
            } else {
                damageSource = DamageSource.m_19370_((LivingEntity)this.owner);
            }
            if (!entity.m_6469_(source = damageSource, damage)) continue;
            hitSomething = true;
            entity.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SUNDERED.get(), this.debuffDuration, MathHelper.weightedRound(strength, this.f_19796_) - 1, false, false));
            entity.m_147240_((double)0.8f, -relPos.m_7096_(), -relPos.m_7094_());
        }
        return hitSomething;
    }
}

