/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.init.CoreFluids;
import cofh.core.item.ItemCoFH;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.XpHelper;
import cofh.lib.api.ContainerType;
import cofh.lib.api.item.IFluidContainerItem;
import cofh.lib.api.item.IXpContainerItem;
import cofh.lib.fluid.FluidContainerItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class XpContainerItem
extends ItemCoFH
implements IXpContainerItem,
IFluidContainerItem {
    protected int xpCapacity;

    public XpContainerItem(Item.Properties builder, int xpCapacity) {
        super(builder);
        this.xpCapacity = xpCapacity;
        this.setEnchantability(5);
    }

    @Override
    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)StringHelper.getTextComponent(StringHelper.localize("info.cofh.amount") + ": " + StringHelper.getScaledNumber(this.getStoredXp(stack)) + " / " + StringHelper.getScaledNumber(this.getCapacityXp(stack))));
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.m_41720_() != oldStack.m_41720_() || !ItemHelper.areItemStacksEqualIgnoreTags(oldStack, newStack, "Fluid");
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags(oldStack, newStack, "Fluid"));
    }

    public boolean m_142522_(ItemStack stack) {
        return !this.isCreative(stack, ContainerType.EXPERIENCE) && this.getStoredXp(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.round(13.0 * (double)this.getStoredXp(stack) / (double)this.getCapacityXp(stack));
    }

    public int m_142159_(ItemStack stack) {
        return 8039506;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (Utils.isFakePlayer((Entity)player)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        int curLevel = player.f_36078_;
        if (player.m_36341_()) {
            int xp = XpHelper.getExtraPlayerXp(player) > 0 ? Math.min(XpHelper.getTotalXpForLevel(player.f_36078_ + 1) - XpHelper.getTotalXpForLevel(player.f_36078_) - XpHelper.getExtraPlayerXp(player), this.getStoredXp(stack)) : Math.min(XpHelper.getTotalXpForLevel(player.f_36078_ + 1) - XpHelper.getTotalXpForLevel(player.f_36078_), this.getStoredXp(stack));
            XpHelper.setPlayerXP(player, XpHelper.getPlayerXP(player) + xp);
            if (player.f_36078_ < curLevel + 1 && XpHelper.getPlayerXP(player) >= XpHelper.getTotalXpForLevel(curLevel + 1)) {
                XpHelper.setPlayerLevel(player, curLevel + 1);
            }
            this.modifyXp(stack, -xp);
        } else if (XpHelper.getExtraPlayerXp(player) > 0) {
            int xp = Math.min(XpHelper.getExtraPlayerXp(player), this.getSpaceXp(stack));
            XpHelper.setPlayerXP(player, XpHelper.getPlayerXP(player) - xp);
            if (player.f_36078_ < curLevel) {
                XpHelper.setPlayerLevel(player, curLevel);
            }
            this.modifyXp(stack, xp);
        } else if (player.f_36078_ > 0) {
            int xp = Math.min(XpHelper.getTotalXpForLevel(player.f_36078_) - XpHelper.getTotalXpForLevel(player.f_36078_ - 1), this.getSpaceXp(stack));
            XpHelper.setPlayerXP(player, XpHelper.getPlayerXP(player) - xp);
            if (player.f_36078_ < curLevel - 1) {
                XpHelper.setPlayerLevel(player, curLevel - 1);
            }
            this.modifyXp(stack, xp);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidContainerItemWrapper(stack, this);
    }

    @Override
    public int getCapacityXp(ItemStack stack) {
        return this.getMaxStored(stack, this.xpCapacity);
    }

    @Override
    public FluidStack getFluid(ItemStack container) {
        int xp = this.getStoredXp(container);
        return xp > 0 ? new FluidStack((Fluid)CoreFluids.EXPERIENCE_FLUID.get(), xp * 20) : FluidStack.EMPTY;
    }

    @Override
    public boolean isFluidValid(ItemStack container, FluidStack resource) {
        return FluidHelper.IS_XP.test(resource);
    }

    @Override
    public int getCapacity(ItemStack container) {
        return this.getCapacityXp(container) * 20;
    }

    @Override
    public int fill(ItemStack container, FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(container, resource)) {
            return 0;
        }
        int xp = this.getStoredXp(container);
        int filled = Math.min(this.getCapacityXp(container) - xp, resource.getAmount() / 20);
        if (action.execute()) {
            this.modifyXp(container, filled);
        }
        return filled * 20;
    }

    @Override
    public FluidStack drain(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        int xp = this.getStoredXp(container);
        if (xp <= 0) {
            return FluidStack.EMPTY;
        }
        int drained = Math.min(xp, maxDrain / 20);
        if (action.execute() && !this.isCreative(container, ContainerType.FLUID)) {
            this.modifyXp(container, -drained);
        }
        return new FluidStack((Fluid)CoreFluids.EXPERIENCE_FLUID.get(), drained * 20);
    }
}

