/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import terrails.colorfulhearts.LoaderExpectPlatform;
import terrails.colorfulhearts.config.ConfigOption;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.config.screen.base.ScrollableWidgetList;
import terrails.colorfulhearts.config.screen.widgets.HeartColorEditBox;
import terrails.colorfulhearts.heart.HeartPiece;
import terrails.colorfulhearts.heart.HeartType;
import terrails.colorfulhearts.render.HeartRenderer;

public class ColorSelectionScreen
extends Screen {
    private final Screen lastScreen;
    private final boolean health;
    private boolean vanillaHeart;
    private boolean hasChanged;
    private List<HeartColorEditBox> editBoxes;
    private List<Button> heartTypeButtons;
    private Button saveButton;
    private ScrollableWidgetList colorSelectionList;
    private HeartType heartType;

    public ColorSelectionScreen(Screen lastScreen, boolean health) {
        super((Component)Component.m_237115_((String)(health ? "colorfulhearts.screen.health.title" : "colorfulhearts.screen.absorption.title")));
        this.lastScreen = lastScreen;
        this.health = health;
        this.updateHeartType(HeartType.NORMAL, false);
    }

    protected void m_7856_() {
        super.m_7856_();
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        int height = Minecraft.m_91087_().m_91268_().m_85446_();
        int marginY = 32;
        double prevScrollAmount = this.colorSelectionList == null ? 0.0 : this.colorSelectionList.m_93517_();
        this.colorSelectionList = (ScrollableWidgetList)this.m_142416_((GuiEventListener)new ScrollableWidgetList(Minecraft.m_91087_(), width, height, marginY, height - marginY, 26));
        this.addColorElements();
        this.colorSelectionList.m_93410_(prevScrollAmount);
        int BUTTON_SPACING = 10;
        int BUTTON_WIDTH = 80;
        int startX = (width - BUTTON_WIDTH * 4 - BUTTON_SPACING * 3) / 2;
        int y = (marginY - 20) / 2;
        this.heartTypeButtons = new ArrayList<Button>();
        Button normalHearts = new Button(startX, y, BUTTON_WIDTH, 20, (Component)Component.m_237115_((String)"colorfulhearts.options.button.hearttype.normal"), btn -> this.updateHeartType(HeartType.NORMAL, true));
        normalHearts.f_93623_ = this.heartType != HeartType.NORMAL;
        this.m_142416_((GuiEventListener)normalHearts);
        this.heartTypeButtons.add(normalHearts);
        int x = startX + BUTTON_WIDTH + BUTTON_SPACING;
        Button poisonedHearts = new Button(x, y, BUTTON_WIDTH, 20, (Component)Component.m_237115_((String)"colorfulhearts.options.button.hearttype.poisoned"), btn -> this.updateHeartType(HeartType.POISONED, true));
        poisonedHearts.f_93623_ = this.heartType != HeartType.POISONED;
        this.m_142416_((GuiEventListener)poisonedHearts);
        this.heartTypeButtons.add(poisonedHearts);
        Button witheredHearts = new Button(x += BUTTON_WIDTH + BUTTON_SPACING, y, BUTTON_WIDTH, 20, (Component)Component.m_237115_((String)"colorfulhearts.options.button.hearttype.withered"), btn -> this.updateHeartType(HeartType.WITHERED, true));
        witheredHearts.f_93623_ = this.heartType != HeartType.WITHERED;
        this.m_142416_((GuiEventListener)witheredHearts);
        this.heartTypeButtons.add(witheredHearts);
        Button frozenHearts = new Button(x += BUTTON_WIDTH + BUTTON_SPACING, y, BUTTON_WIDTH, 20, (Component)Component.m_237115_((String)"colorfulhearts.options.button.hearttype.frozen"), btn -> this.updateHeartType(HeartType.FROZEN, true));
        frozenHearts.f_93623_ = this.heartType != HeartType.FROZEN;
        this.m_142416_((GuiEventListener)frozenHearts);
        this.heartTypeButtons.add(frozenHearts);
        BUTTON_WIDTH = 120;
        BUTTON_SPACING = 30;
        startX = (width - BUTTON_WIDTH * 2 - BUTTON_SPACING) / 2;
        y = height - 10 - marginY / 2;
        Button saveButton = new Button(startX, y, BUTTON_WIDTH, 20, (Component)Component.m_237115_((String)"colorfulhearts.options.button.confirmsave"), btn -> {
            this.saveConfig();
            HeartRenderer.INSTANCE.lastHeartType = null;
            this.m_7379_();
        });
        saveButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)saveButton);
        this.saveButton = saveButton;
        x = startX + BUTTON_WIDTH + BUTTON_SPACING;
        Button cancelButton = new Button(x, y, BUTTON_WIDTH, 20, (Component)Component.m_237115_((String)"colorfulhearts.options.button.cancel"), btn -> this.m_7379_());
        this.m_142416_((GuiEventListener)cancelButton);
        if (this.hasChanged) {
            this.heartTypeButtons.forEach(btn -> {
                btn.f_93623_ = false;
            });
        }
        if (this.canSave()) {
            this.saveButton.f_93623_ = true;
        }
    }

    public void updateHeartType(HeartType type, boolean rebuildWidgets) {
        this.heartType = type;
        this.vanillaHeart = this.hasVanillaHeartVariant() && this.heartColorsContainVanilla();
        this.editBoxes = null;
        if (rebuildWidgets) {
            this.m_232761_();
        }
    }

    public boolean canSave() {
        boolean invalidColorsPresent = this.editBoxes.stream().anyMatch(box -> !box.isValidHex());
        long colorCount = this.editBoxes.stream().filter(HeartColorEditBox::isValidHex).count();
        boolean hasEnoughColors = colorCount > 0L && (this.health && (this.heartType == HeartType.NORMAL || this.vanillaHeart || colorCount == 2L) || !this.health && (this.heartType == HeartType.NORMAL || colorCount == 2L));
        return this.hasChanged && !invalidColorsPresent && hasEnoughColors;
    }

    public boolean hasVanillaHeartVariant() {
        return this.health || this.heartType == HeartType.NORMAL;
    }

    private boolean haveValuesChanged() {
        boolean hasVanillaOptionChanged;
        List<HeartPiece> pieces = this.heartColorsWithoutVanilla();
        boolean isSizeEqual = pieces.size() == this.editBoxes.size();
        boolean bl = hasVanillaOptionChanged = !this.hasVanillaHeartVariant() || this.heartType == HeartType.NORMAL && this.vanillaHeart == this.configVanillaHeart().get() || this.heartType != HeartType.NORMAL && this.vanillaHeart == this.heartColorsContainVanilla();
        if (isSizeEqual && hasVanillaOptionChanged) {
            for (int i = 0; i < pieces.size(); ++i) {
                HeartColorEditBox box = this.editBoxes.get(i);
                HeartPiece piece = pieces.get(i);
                if (box.isValidHex() && piece.getHexColor().equalsIgnoreCase(box.m_94155_())) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private List<HeartPiece> heartColorsWithoutVanilla() {
        ArrayList<HeartPiece> pieces = new ArrayList<HeartPiece>(HeartPiece.getHeartPiecesForType(this.heartType, !this.health));
        if (this.health) {
            pieces.remove(HeartPiece.VANILLA_HEALTH);
        } else {
            pieces.remove(HeartPiece.VANILLA_ABSORPTION);
        }
        return pieces;
    }

    private boolean heartColorsContainVanilla() {
        ArrayList<HeartPiece> pieces = new ArrayList<HeartPiece>(HeartPiece.getHeartPiecesForType(this.heartType, !this.health));
        if (this.health) {
            return pieces.contains(HeartPiece.VANILLA_HEALTH);
        }
        return pieces.contains(HeartPiece.VANILLA_ABSORPTION);
    }

    private ConfigOption<Boolean> configVanillaHeart() {
        if (this.health) {
            return Configuration.HEALTH.vanillaHearts;
        }
        return Configuration.ABSORPTION.vanillaHearts;
    }

    private void saveConfig() {
        List<HeartPiece> heartPieces = this.editBoxes.stream().filter(HeartColorEditBox::isValidHex).map(HeartColorEditBox::getHeartPiece).collect(Collectors.toList());
        if (this.hasVanillaHeartVariant() && this.vanillaHeart) {
            if (this.health) {
                heartPieces.add(0, HeartPiece.VANILLA_HEALTH);
            } else {
                heartPieces.add(0, HeartPiece.VANILLA_ABSORPTION);
            }
        }
        if (this.health) {
            switch (this.heartType) {
                case NORMAL: {
                    Configuration.HEALTH.colors.set(HeartPiece.getColorList(heartPieces));
                    Configuration.HEALTH.vanillaHearts.set(this.vanillaHeart);
                    break;
                }
                case POISONED: {
                    Configuration.HEALTH.poisonedColors.set(HeartPiece.getColorList(heartPieces));
                    break;
                }
                case WITHERED: {
                    Configuration.HEALTH.witheredColors.set(HeartPiece.getColorList(heartPieces));
                    break;
                }
                case FROZEN: {
                    Configuration.HEALTH.frozenColors.set(HeartPiece.getColorList(heartPieces));
                }
            }
        } else {
            switch (this.heartType) {
                case NORMAL: {
                    Configuration.ABSORPTION.colors.set(HeartPiece.getColorList(heartPieces));
                    Configuration.ABSORPTION.vanillaHearts.set(this.vanillaHeart);
                    break;
                }
                case POISONED: {
                    Configuration.ABSORPTION.poisonedColors.set(HeartPiece.getColorList(heartPieces));
                    break;
                }
                case WITHERED: {
                    Configuration.ABSORPTION.witheredColors.set(HeartPiece.getColorList(heartPieces));
                    break;
                }
                case FROZEN: {
                    Configuration.ABSORPTION.frozenColors.set(HeartPiece.getColorList(heartPieces));
                }
            }
        }
        LoaderExpectPlatform.applyConfig();
    }

    private void addColorElements() {
        int ELEMENTS_PER_ROW = 4;
        int ELEMENT_SPACING = 6;
        int EDIT_BOX_WIDTH = 60;
        int BUTTON_DIMS = 20;
        int BUTTON_SPACING = 3;
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int totalElementWidth = 350;
        int startX = (screenWidth - totalElementWidth) / 2;
        ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        int OFFSET = 0;
        if (this.hasVanillaHeartVariant()) {
            OFFSET = 1;
            Supplier<Component> componentSupplier = () -> {
                if (this.vanillaHeart) {
                    return Component.m_237115_((String)"colorfulhearts.options.button.vanillaheart.true");
                }
                return Component.m_237115_((String)"colorfulhearts.options.button.vanillaheart.false");
            };
            Button vanillaHeart = new Button(startX, 0, 83, 20, componentSupplier.get(), btn -> {
                this.vanillaHeart = !this.vanillaHeart;
                this.hasChanged = this.haveValuesChanged();
                btn.m_93666_((Component)componentSupplier.get());
                this.m_232761_();
            });
            widgets.add((AbstractWidget)vanillaHeart);
        }
        if (this.editBoxes == null) {
            this.editBoxes = new ArrayList<HeartColorEditBox>();
            List<HeartPiece> pieces = this.heartColorsWithoutVanilla();
            for (HeartPiece piece : pieces) {
                HeartColorEditBox box = new HeartColorEditBox(this.f_96547_, 0, 0, 0, 0, (Component)Component.m_237119_(), this.heartType, this.health);
                box.m_94144_(piece.getHexColor());
                this.editBoxes.add(box);
            }
        }
        int elementCount = this.editBoxes.size();
        for (int i = 0; i < elementCount; ++i) {
            boolean canHaveMoreHearts;
            boolean isRowDone;
            boolean stopRendering;
            boolean bl = stopRendering = this.health && this.heartType != HeartType.NORMAL && (i > 0 && this.vanillaHeart || i > 1);
            if (stopRendering) {
                this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
                break;
            }
            int index = i;
            int column = (i + OFFSET) % 4;
            int x = startX + column * 89;
            Button button = new Button(x, 0, 20, 20, (Component)Component.m_237113_((String)"-").m_130940_(ChatFormatting.RED), btn -> {
                this.editBoxes.remove(index);
                this.hasChanged = this.haveValuesChanged();
                this.m_232761_();
            });
            HeartColorEditBox box = this.editBoxes.get(index);
            box = new HeartColorEditBox(this.f_96547_, x + 20 + 3, 0, 58, 20, box, (Component)Component.m_237119_(), this.heartType, this.health);
            box.m_94151_(str -> {
                this.hasChanged = this.haveValuesChanged();
            });
            this.editBoxes.set(index, box);
            widgets.add((AbstractWidget)button);
            widgets.add((AbstractWidget)box);
            boolean isFinished = index + 1 == elementCount;
            boolean bl2 = isRowDone = column + 1 == 4;
            if (isRowDone) {
                this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
                widgets.clear();
            }
            if (!isFinished) continue;
            boolean bl3 = canHaveMoreHearts = this.heartType == HeartType.NORMAL || elementCount < 2 && !this.vanillaHeart;
            if (canHaveMoreHearts) {
                column = (column + 1) % 4;
                x = startX + column * 60 + column * 20 + column * 6 + column * 3;
                Button addButton = new Button(x, 0, 20, 20, (Component)Component.m_237113_((String)"+").m_130940_(ChatFormatting.GREEN), btn -> {
                    this.editBoxes.add(new HeartColorEditBox(this.f_96547_, 0, 0, 38, 20, (Component)Component.m_237119_(), this.heartType, this.health));
                    this.hasChanged = this.haveValuesChanged();
                    this.m_232761_();
                });
                widgets.add((AbstractWidget)addButton);
            }
            this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
        }
        if (this.editBoxes.size() == 0) {
            int x = startX + 60 + 20 + 6 + 3;
            Button addButton = new Button(x, 0, 20, 20, (Component)Component.m_237113_((String)"+").m_130940_(ChatFormatting.GREEN), btn -> {
                this.editBoxes.add(new HeartColorEditBox(this.f_96547_, 0, 0, 38, 20, (Component)Component.m_237119_(), this.heartType, this.health));
                this.m_232761_();
            });
            widgets.add((AbstractWidget)addButton);
            this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
        }
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.hasChanged) {
            this.heartTypeButtons.forEach(btn -> {
                btn.f_93623_ = false;
            });
            this.saveButton.f_93623_ = this.canSave();
        } else if (this.saveButton.f_93623_) {
            this.m_232761_();
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.lastScreen);
    }
}

