/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.heart;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.heart.HeartType;
import terrails.colorfulhearts.render.RenderUtils;

public class HeartPiece {
    public static final HeartPiece VANILLA_HEALTH = new HeartPiece(false);
    public static final HeartPiece VANILLA_ABSORPTION = new HeartPiece(true);
    private final Integer color;
    private final boolean absorption;

    protected HeartPiece(int color, boolean absorption) {
        this.absorption = absorption;
        this.color = color;
    }

    private HeartPiece(boolean absorption) {
        this.absorption = absorption;
        this.color = null;
    }

    public static HeartPiece custom(int color, boolean absorption) {
        return new HeartPiece(color, absorption);
    }

    public static HeartPiece custom(String hexColor, boolean absorption) {
        return HeartPiece.custom(Integer.parseInt(hexColor.substring(1), 16), absorption);
    }

    public Integer getColor() {
        return this.color;
    }

    public boolean isAbsorption() {
        return this.absorption;
    }

    public boolean isVanilla() {
        return this.color == null;
    }

    public String getHexColor() {
        if (this.isVanilla()) {
            return "Vanilla";
        }
        return "#" + String.format("%06X", this.color).toUpperCase(Locale.ROOT);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            HeartPiece part = (HeartPiece)obj;
            return Objects.equals(this.color, part.color) && this.absorption == part.absorption;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.absorption, this.color);
    }

    public String toString() {
        return (this.isAbsorption() ? "Absorption " : "Health ") + this.getHexColor();
    }

    public void draw(PoseStack poseStack, int xPos, int yPos, boolean blinking, boolean hardcore, HeartType type) {
        this.draw(poseStack, xPos, yPos, blinking, hardcore, type, Part.FULL);
    }

    public void draw(PoseStack poseStack, int xPos, int yPos, boolean blinking, boolean hardcore, HeartType type, boolean firstHalf) {
        this.draw(poseStack, xPos, yPos, blinking, hardcore, type, firstHalf ? Part.FIRST_HALF : Part.SECOND_HALF);
    }

    private void draw(PoseStack poseStack, int xPos, int yPos, boolean blinking, boolean hardcore, HeartType type, Part part) {
        xPos += part == Part.SECOND_HALF ? 5 : 0;
        int xTex = type.getX(part.getXOffset(), this.isVanilla(), this.isAbsorption(), blinking);
        assert (Minecraft.m_91087_().f_91073_ != null);
        int yTex = hardcore ? (this.isVanilla() ? 45 : 36) : 0;
        int x2 = part == Part.FULL || part == Part.FIRST_HALF ? 9 : 5;
        int y2 = 9;
        if (this.isVanilla()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
            RenderUtils.drawTexture(poseStack, xPos, xPos + x2, yPos, yPos + y2, xTex, xTex + x2, yTex, yTex + y2);
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)(this.isAbsorption() ? CColorfulHearts.ABSORPTION_ICONS_LOCATION : CColorfulHearts.HEALTH_ICONS_LOCATION));
            RenderUtils.drawTexture(poseStack, xPos, xPos + x2, yPos, yPos + y2, xTex, xTex + x2, yTex, yTex + y2, this.getColor(), 255);
            yTex += y2;
            if (hardcore) {
                RenderUtils.drawTexture(poseStack, xPos, xPos + x2, yPos, yPos + y2, xTex, xTex + x2, yTex, yTex + y2, 255);
            } else {
                RenderUtils.drawTexture(poseStack, xPos, xPos + x2, yPos, yPos + y2, xTex, xTex + x2, yTex, yTex + y2, 255);
            }
            RenderUtils.drawTexture(poseStack, xPos, xPos + x2, yPos, yPos + y2, xTex, xTex + x2, yTex += y2, yTex + y2, 255);
            if (blinking && !this.isAbsorption()) {
                RenderUtils.drawTexture(poseStack, xPos, xPos + x2, yPos, yPos + y2, xTex, xTex + x2, yTex -= 2 * y2, yTex + y2, type == HeartType.WITHERED ? 56 : 127);
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        }
    }

    public static List<HeartPiece> getColorsFromConfig(List<? extends String> configValue, boolean isAbsorption, boolean isEffect) {
        boolean notEnoughAbsorptionEffectColours;
        ArrayList<HeartPiece> colors = new ArrayList<HeartPiece>();
        int valueCount = configValue.size();
        String typeName = (isAbsorption ? "Absorption" : "Health") + (isEffect ? " Effect" : "");
        boolean noValues = configValue.isEmpty();
        if (noValues) {
            String error = typeName + " colors not defined";
            CColorfulHearts.LOGGER.error(error);
            throw new IllegalArgumentException(error);
        }
        boolean bl = notEnoughAbsorptionEffectColours = isAbsorption && isEffect && valueCount != 2;
        if (notEnoughAbsorptionEffectColours) {
            String error = typeName + " colors must be empty or have 2 values.";
            CColorfulHearts.LOGGER.error(error);
            throw new IllegalArgumentException(error);
        }
        if (!isEffect && isAbsorption && Configuration.ABSORPTION.vanillaHearts.get().booleanValue()) {
            colors.add(VANILLA_ABSORPTION);
        } else if (!isEffect && !isAbsorption && Configuration.HEALTH.vanillaHearts.get().booleanValue()) {
            colors.add(VANILLA_HEALTH);
        } else if (isEffect && !isAbsorption && valueCount == 1) {
            colors.add(VANILLA_HEALTH);
        }
        for (String string : configValue) {
            HeartPiece piece = HeartPiece.custom(string, isAbsorption);
            colors.add(piece);
        }
        return ImmutableList.copyOf(colors);
    }

    public static List<String> getColorList(List<HeartPiece> pieces) {
        return pieces.stream().filter(value -> !value.isVanilla()).map(HeartPiece::getHexColor).collect(Collectors.toList());
    }

    public static List<HeartPiece> getHeartPiecesForType(HeartType heartType, boolean absorption) {
        if (absorption) {
            return switch (heartType) {
                default -> throw new IncompatibleClassChangeError();
                case HeartType.NORMAL -> HeartPiece.getColorsFromConfig(Configuration.ABSORPTION.colors.get(), true, false);
                case HeartType.POISONED -> HeartPiece.getColorsFromConfig(Configuration.ABSORPTION.poisonedColors.get(), true, true);
                case HeartType.WITHERED -> HeartPiece.getColorsFromConfig(Configuration.ABSORPTION.witheredColors.get(), true, true);
                case HeartType.FROZEN -> HeartPiece.getColorsFromConfig(Configuration.ABSORPTION.frozenColors.get(), true, true);
            };
        }
        return switch (heartType) {
            default -> throw new IncompatibleClassChangeError();
            case HeartType.NORMAL -> HeartPiece.getColorsFromConfig(Configuration.HEALTH.colors.get(), false, false);
            case HeartType.POISONED -> HeartPiece.getColorsFromConfig(Configuration.HEALTH.poisonedColors.get(), false, true);
            case HeartType.WITHERED -> HeartPiece.getColorsFromConfig(Configuration.HEALTH.witheredColors.get(), false, true);
            case HeartType.FROZEN -> HeartPiece.getColorsFromConfig(Configuration.HEALTH.frozenColors.get(), false, true);
        };
    }

    private static enum Part {
        FULL(0),
        FIRST_HALF(9),
        SECOND_HALF(5);

        private final int x;

        private Part(int x) {
            this.x = x;
        }

        public int getXOffset() {
            return this.x;
        }
    }
}

