/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.heart.Heart;
import terrails.colorfulhearts.heart.HeartPiece;
import terrails.colorfulhearts.heart.HeartType;

public class HeartRenderer {
    public static final HeartRenderer INSTANCE = new HeartRenderer();
    private final Minecraft client = Minecraft.m_91087_();
    private final Random random = new Random();
    private int lastHealth;
    private int lastMaxHealth;
    private int lastAbsorption;
    public HeartType lastHeartType;
    private Heart[] hearts;

    public void renderPlayerHearts(PoseStack poseStack, Player player, int x, int y, int maxHealth, int currentHealth, int displayHealth, int absorption, boolean renderHighlight) {
        int healthHearts = Mth.m_14165_((double)((double)Math.min(maxHealth, 20) / 2.0));
        int displayHealthHearts = Mth.m_14165_((double)((double)Math.min(displayHealth, 20) / 2.0));
        boolean absorptionSameRow = Configuration.ABSORPTION.renderOverHealth.get();
        int regenIndex = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            long tickCount = this.client.f_91065_.m_93079_();
            if (absorptionSameRow && absorption + Math.max(currentHealth, displayHealth) > maxHealth) {
                int value = Math.min(20, Math.max(currentHealth, displayHealth) + absorption);
                regenIndex = (int)tickCount % Mth.m_14167_((float)(value + 5));
            } else {
                regenIndex = (int)tickCount % Mth.m_14167_((float)(Math.min(maxHealth, 20) + 5));
            }
        }
        HeartType heartType = HeartType.forPlayer(player);
        if (this.lastHealth != currentHealth || this.lastMaxHealth != maxHealth || this.lastAbsorption != absorption || this.lastHeartType != heartType || this.hearts == null) {
            List<HeartPiece> healthColors = HeartPiece.getHeartPiecesForType(heartType, false);
            List<HeartPiece> absorptionColors = HeartPiece.getHeartPiecesForType(heartType, true);
            this.hearts = Heart.calculateHearts(absorption, currentHealth, maxHealth, healthColors, absorptionColors, absorptionSameRow);
            this.lastHealth = currentHealth;
            this.lastMaxHealth = maxHealth;
            this.lastAbsorption = absorption;
            this.lastHeartType = heartType;
            CColorfulHearts.LOGGER.debug("Successfully updated hearts.\n{}", (Object)Arrays.toString(this.hearts));
        }
        RenderSystem.m_69478_();
        for (int index = 0; index < this.hearts.length; ++index) {
            Heart heart = this.hearts[index];
            if (heart == null) continue;
            int xPos = x + index % 10 * 8;
            int yPos = y - (index > 9 ? 10 : 0);
            if (currentHealth + absorption <= 4) {
                yPos += this.random.nextInt(2);
            }
            if ((index < healthHearts || absorptionSameRow) && index == regenIndex) {
                yPos -= 2;
            }
            boolean highlightHeart = renderHighlight && index < displayHealthHearts;
            heart.draw(poseStack, xPos, yPos, renderHighlight, highlightHeart, heartType);
        }
        RenderSystem.m_69461_();
    }
}

