/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting;

import dev.compactmods.crafting.client.ClientConfig;
import dev.compactmods.crafting.client.ui.container.ContainerRegistration;
import dev.compactmods.crafting.core.CCBlocks;
import dev.compactmods.crafting.core.CCCatalystTypes;
import dev.compactmods.crafting.core.CCItems;
import dev.compactmods.crafting.core.CCLayerTypes;
import dev.compactmods.crafting.core.CCMiniaturizationRecipes;
import dev.compactmods.crafting.network.NetworkHandler;
import dev.compactmods.crafting.recipes.components.ComponentRegistration;
import dev.compactmods.crafting.server.ServerConfig;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="compactcrafting")
public class CompactCrafting {
    public static final Logger LOGGER = LogManager.getLogger((String)"compactcrafting");
    public static final Logger RECIPE_LOGGER = LogManager.getLogger((String)"CCRecipeLoader");
    public static final String MOD_ID = "compactcrafting";
    public static final CreativeModeTab ITEM_GROUP = new CCItemGroup();

    public CompactCrafting() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        ModLoadingContext mlCtx = ModLoadingContext.get();
        mlCtx.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CONFIG);
        mlCtx.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.CONFIG);
        CCBlocks.init(modBus);
        CCCatalystTypes.init(modBus);
        CCItems.init(modBus);
        CCLayerTypes.init(modBus);
        CCMiniaturizationRecipes.init(modBus);
        ComponentRegistration.init(modBus);
        ContainerRegistration.init(modBus);
    }

    private void setup(FMLCommonSetupEvent event) {
        NetworkHandler.initialize();
    }

    public static class CCItemGroup
    extends CreativeModeTab {
        public CCItemGroup() {
            super(CompactCrafting.MOD_ID);
        }

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)CCItems.FIELD_PROJECTOR_ITEM.get());
        }
    }
}

