/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.client.fakeworld;

import dev.compactmods.crafting.api.components.IRecipeBlockComponent;
import dev.compactmods.crafting.api.recipe.layers.IRecipeLayer;
import dev.compactmods.crafting.client.fakeworld.RenderingWorld;
import dev.compactmods.crafting.recipes.MiniaturizationRecipe;
import dev.compactmods.crafting.util.BlockSpaceUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeChunk
extends EmptyLevelChunk {
    private final MiniaturizationRecipe recipe;
    private final Map<BlockPos, BlockState> blockCache;
    private final Map<BlockPos, BlockEntity> tileCache;

    public RecipeChunk(RenderingWorld renderingLevel, ChunkPos chunkPos, MiniaturizationRecipe recipe) {
        super((Level)renderingLevel, chunkPos, (Holder)ForgeRegistries.BIOMES.getHolder(Biomes.f_48173_).get());
        this.recipe = recipe;
        this.blockCache = new HashMap<BlockPos, BlockState>();
        this.tileCache = new HashMap<BlockPos, BlockEntity>();
        BlockSpaceUtil.getBlocksIn(recipe.getDimensions()).forEach(pos -> {
            EntityBlock eb;
            BlockEntity tile;
            int y = pos.m_123342_();
            Optional<IRecipeLayer> layer = recipe.getLayer(y);
            if (!layer.isPresent()) {
                return;
            }
            IRecipeLayer rLayer = layer.get();
            Optional<String> componentForPosition = rLayer.getComponentForPosition(pos.m_6625_(y));
            BlockState posState = componentForPosition.flatMap(recipe.getComponents()::getBlock).map(IRecipeBlockComponent::getRenderState).orElse(Blocks.f_50626_.m_49966_());
            this.blockCache.put((BlockPos)pos, posState);
            Block patt2240$temp = posState.m_60734_();
            if (patt2240$temp instanceof EntityBlock && (tile = (eb = (EntityBlock)patt2240$temp).m_142194_(pos.m_7949_(), posState)) != null) {
                tile.m_142339_((Level)renderingLevel);
                this.tileCache.put(pos.m_7949_(), tile);
            }
        });
    }

    public BlockState m_8055_(BlockPos pos) {
        if (this.blockCache.containsKey(pos)) {
            return this.blockCache.get(pos);
        }
        return Blocks.f_50626_.m_49966_();
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        return this.tileCache.get(pos);
    }

    @Nullable
    public BlockEntity m_5685_(BlockPos pos, LevelChunk.EntityCreationType createType) {
        return this.tileCache.get(pos);
    }
}

