/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.datagen;

import dev.compactmods.crafting.core.CCBlocks;
import dev.compactmods.crafting.datagen.SharedStateGenerator;
import dev.compactmods.crafting.projector.FieldProjectorBlock;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ProjectorStateGenerator
extends BlockStateProvider {
    public ProjectorStateGenerator(DataGenerator gen, ExistingFileHelper files) {
        super(gen, "compactcrafting", files);
    }

    protected void registerStatesAndModels() {
        this.projectorDishModel();
        this.projectorStaticModel();
        this.getVariantBuilder((Block)CCBlocks.FIELD_PROJECTOR_BLOCK.get()).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)FieldProjectorBlock.FACING);
            boolean active = FieldProjectorBlock.isActive(state);
            if (active) {
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/base"))).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/field_projector_static"))).rotationY(((int)dir.m_122435_() - 90) % 360).build();
        });
        ((ItemModelBuilder)this.itemModels().withExistingParent("projector_dish", this.modLoc("block/field_projector_dish"))).transforms().transform(ItemTransforms.TransformType.GUI).rotation(33.75f, 45.0f, 0.0f).translation(2.0f, -2.0f, 0.0f).scale(1.0f, 1.0f, 1.0f).end();
        ((ItemModelBuilder)this.itemModels().withExistingParent("field_projector", this.modLoc("block/field_projector_static"))).transforms().transform(ItemTransforms.TransformType.GUI).rotation(33.75f, 45.0f, 0.0f).translation(0.0f, 1.0f, 0.0f).scale(0.6f, 0.6f, 0.6f).end();
    }

    private void projectorStaticModel() {
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/field_projector_static")).texture("particle", this.modLoc("block/projector_base_bottom"));
        SharedStateGenerator.addProjectorBase(builder);
        this.addDishModel(builder);
    }

    private void projectorDishModel() {
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/field_projector_dish")).texture("particle", this.modLoc("block/projector_dish_back"));
        this.addDishModel(builder);
    }

    private void addDishModel(BlockModelBuilder builder) {
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.texture("dish_front", this.modLoc("block/projector_dish_front"))).texture("dish_front_sides", this.modLoc("block/projector_dish_front_sides"))).texture("dish_back", this.modLoc("block/projector_dish_back"))).texture("dish_connector", this.modLoc("block/projector_dish_connector"));
        builder.element().from(4.0f, 8.0f, 3.0f).to(6.0f, 16.0f, 13.0f).allFaces((dir, face) -> {
            switch (dir) {
                case UP: {
                    face.texture("#dish_front_sides").uvs(1.0f, 0.0f, 11.0f, 1.0f).end();
                    break;
                }
                case DOWN: {
                    face.texture("#dish_front_sides").uvs(1.0f, 9.0f, 11.0f, 10.0f).end();
                    break;
                }
                case EAST: {
                    face.texture("#dish_back").uvs(0.0f, 0.0f, 10.0f, 8.0f).end();
                    break;
                }
                case WEST: {
                    face.texture("#dish_front_sides").uvs(1.0f, 1.0f, 11.0f, 9.0f).end();
                    break;
                }
                case NORTH: {
                    face.texture("#dish_front_sides").uvs(0.0f, 1.0f, 1.0f, 9.0f).end();
                    break;
                }
                case SOUTH: {
                    face.texture("#dish_front_sides").uvs(11.0f, 1.0f, 12.0f, 9.0f).end();
                }
            }
        }).shade(true).end();
        builder.element().from(4.0f, 8.0f, 3.0f).to(5.0f, 16.0f, 13.0f).allFaces((dir, face) -> {
            if (dir == Direction.WEST) {
                face.texture("#dish_front").uvs(0.0f, 0.0f, 10.0f, 8.0f).tintindex(0).end();
            } else {
                face.texture("#dish_front").uvs(0.0f, 0.0f, 1.0f, 1.0f).cullface(dir.m_122424_()).end();
            }
        }).end();
        builder.element().from(6.0f, 11.0f, 7.0f).to(7.0f, 13.0f, 9.0f).allFaces((dir, face) -> {
            switch (dir) {
                case UP: {
                    face.texture("#dish_connector").uvs(1.0f, 0.0f, 3.0f, 1.0f).end();
                    break;
                }
                case DOWN: {
                    face.texture("#dish_connector").uvs(1.0f, 3.0f, 3.0f, 4.0f).end();
                    break;
                }
                case EAST: {
                    face.texture("#dish_connector").uvs(1.0f, 1.0f, 3.0f, 3.0f).end();
                    break;
                }
                case NORTH: {
                    face.texture("#dish_connector").uvs(0.0f, 1.0f, 1.0f, 3.0f).end();
                    break;
                }
                case SOUTH: {
                    face.texture("#dish_connector").uvs(3.0f, 1.0f, 4.0f, 3.0f).end();
                }
            }
        }).end();
    }
}

