/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.projector;

import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.api.field.MiniaturizationFieldSize;
import dev.compactmods.crafting.core.CCCapabilities;
import dev.compactmods.crafting.field.MiniaturizationField;
import dev.compactmods.crafting.network.FieldActivatedPacket;
import dev.compactmods.crafting.network.NetworkHandler;
import dev.compactmods.crafting.projector.FieldProjectorEntity;
import dev.compactmods.crafting.projector.ProjectorHelper;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class FieldProjectorBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<MiniaturizationFieldSize> SIZE = EnumProperty.m_61587_((String)"field", MiniaturizationFieldSize.class);
    private static final VoxelShape BASE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.375, (double)1.0);
    private static final VoxelShape POLE = Shapes.m_83048_((double)0.4375, (double)0.375, (double)0.4375, (double)0.5625, (double)0.75, (double)0.5625);
    private static final VoxelShape DISH_WEST = Shapes.m_83048_((double)0.1875, (double)0.5, (double)0.1875, (double)0.4375, (double)1.0, (double)0.8125);
    private static final VoxelShape DISH_EAST = Shapes.m_83048_((double)0.5625, (double)0.5, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
    private static final VoxelShape DISH_NORTH = Shapes.m_83048_((double)0.1875, (double)0.5, (double)0.1875, (double)0.8125, (double)1.0, (double)0.4375);
    private static final VoxelShape DISH_SOUTH = Shapes.m_83048_((double)0.1875, (double)0.5, (double)0.5625, (double)0.8125, (double)1.0, (double)0.8125);

    public FieldProjectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SIZE, (Comparable)((Object)MiniaturizationFieldSize.INACTIVE)));
    }

    public static Optional<Direction> getDirection(BlockGetter world, BlockPos position) {
        BlockState positionState = world.m_8055_(position);
        if (!(positionState.m_60734_() instanceof FieldProjectorBlock)) {
            return Optional.empty();
        }
        Direction facing = (Direction)positionState.m_61143_((Property)FACING);
        return Optional.of(facing);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter levelReader, BlockPos pos, CollisionContext ctx) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        switch (dir) {
            case WEST: {
                return Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{POLE, DISH_WEST});
            }
            case NORTH: {
                return Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{POLE, DISH_NORTH});
            }
            case EAST: {
                return Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{POLE, DISH_EAST});
            }
            case SOUTH: {
                return Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{POLE, DISH_SOUTH});
            }
        }
        return Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)POLE);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.m_83040_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{SIZE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction looking = context.m_8125_();
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            looking = looking.m_122424_();
        }
        Stream<BlockPos> missing = ProjectorHelper.getMissingProjectors((BlockGetter)level, pos, looking);
        BlockPos[] missingSpots = (BlockPos[])missing.toArray(BlockPos[]::new);
        boolean hasMissing = Arrays.stream(missingSpots).anyMatch(p -> !p.equals((Object)pos));
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)looking);
        if (!hasMissing) {
            MiniaturizationFieldSize size = ProjectorHelper.getClosestOppositeSize((BlockGetter)level, pos, looking).orElse(MiniaturizationFieldSize.INACTIVE);
            state = (BlockState)state.m_61124_(SIZE, (Comparable)((Object)size));
        } else {
            state = (BlockState)state.m_61124_(SIZE, (Comparable)((Object)MiniaturizationFieldSize.INACTIVE));
        }
        return state;
    }

    public static boolean isActive(BlockState state) {
        return state.m_61143_(SIZE) != MiniaturizationFieldSize.INACTIVE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (world.f_46443_) {
            boolean hasMissing = ProjectorHelper.getMissingProjectors((BlockGetter)world, pos, (Direction)state.m_61143_((Property)FACING)).findAny().isPresent();
            if (hasMissing) {
                player.getCapability(CCCapabilities.TEMP_PROJECTOR_RENDERING).ifPresent(rend -> {
                    rend.resetRenderTime();
                    rend.setProjector(world, pos);
                });
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public static BlockPos getFieldCenter(BlockState state, BlockPos projector) {
        return ((MiniaturizationFieldSize)((Object)state.m_61143_(SIZE))).getCenterFromProjector(projector, (Direction)state.m_61143_((Property)FACING));
    }

    public static void deactivateProjector(Level level, BlockPos pos) {
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_60734_() instanceof FieldProjectorBlock) {
            BlockState newState = (BlockState)currentState.m_61124_(SIZE, (Comparable)((Object)MiniaturizationFieldSize.INACTIVE));
            level.m_7731_(pos, newState, 3);
        }
    }

    public static void activateProjector(Level level, BlockPos pos, MiniaturizationFieldSize fieldSize) {
        if (level.m_46749_(pos)) {
            BlockState currentState = level.m_8055_(pos);
            if (!(currentState.m_60734_() instanceof FieldProjectorBlock)) {
                return;
            }
            if (currentState.m_61143_(SIZE) != fieldSize) {
                BlockState newState = (BlockState)currentState.m_61124_(SIZE, (Comparable)((Object)fieldSize));
                level.m_7731_(pos, newState, 3);
            }
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean b) {
        if (!FieldProjectorBlock.isActive(state)) {
            return;
        }
        MiniaturizationFieldSize fieldSize = (MiniaturizationFieldSize)((Object)state.m_61143_(SIZE));
        BlockPos fieldCenter = fieldSize.getCenterFromProjector(pos, (Direction)state.m_61143_((Property)FACING));
        boolean hasMissing = ProjectorHelper.getMissingProjectors((BlockGetter)level, pos, (Direction)state.m_61143_((Property)FACING)).findAny().isPresent();
        if (hasMissing) {
            level.m_7731_(pos, (BlockState)state.m_61124_(SIZE, (Comparable)((Object)MiniaturizationFieldSize.INACTIVE)), 3);
        } else {
            MinecraftServer server = level.m_7654_();
            if (server == null) {
                return;
            }
            if (level.isAreaLoaded(fieldCenter, fieldSize.getProjectorDistance())) {
                fieldSize.getProjectorLocations(fieldCenter).forEach(proj -> FieldProjectorBlock.activateProjector(level, proj, fieldSize));
                BlockPos center = FieldProjectorBlock.getFieldCenter(state, pos);
                level.getCapability(CCCapabilities.FIELDS).ifPresent(fields -> {
                    if (!fields.hasActiveField(center)) {
                        IMiniaturizationField field = fields.registerField(MiniaturizationField.fromSizeAndCenter(fieldSize, center));
                        field.checkLoaded();
                        field.fieldContentsChanged();
                        NetworkHandler.MAIN_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(field.getCenter())), (Object)new FieldActivatedPacket(field));
                    }
                });
            }
        }
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean p_196243_5_) {
        BlockPos fieldCenter = FieldProjectorBlock.getFieldCenter(oldState, pos);
        MiniaturizationFieldSize fieldSize = (MiniaturizationFieldSize)((Object)oldState.m_61143_(SIZE));
        if (FieldProjectorBlock.isActive(oldState)) {
            fieldSize.getProjectorLocations(fieldCenter).forEach(proj -> FieldProjectorBlock.deactivateProjector(level, proj));
            level.getCapability(CCCapabilities.FIELDS).ifPresent(fields -> {
                if (fields.hasActiveField(fieldCenter)) {
                    IMiniaturizationField field = fields.get(fieldCenter).orElse(null);
                    if (field == null) {
                        return;
                    }
                    if (field.enabled()) {
                        fields.unregisterField(fieldCenter);
                        field.handleDestabilize();
                        field.dispose();
                    }
                }
            });
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block changer, BlockPos changedPos, boolean update) {
        super.m_6861_(state, level, pos, changer, changedPos, update);
        if (level.f_46443_) {
            return;
        }
        if (FieldProjectorBlock.isActive(state)) {
            BlockEntity tile = level.m_7702_(pos);
            if (tile instanceof FieldProjectorEntity) {
                FieldProjectorEntity fpt = (FieldProjectorEntity)tile;
                if (level.m_46755_(pos) > 0) {
                    fpt.getField().ifPresent(IMiniaturizationField::disable);
                } else {
                    fpt.getField().ifPresent(IMiniaturizationField::checkRedstone);
                }
            }
        } else {
            ProjectorHelper.getClosestOppositeSize((BlockGetter)level, pos).ifPresent(size -> {
                BlockPos center = size.getCenterFromProjector(pos, (Direction)state.m_61143_((Property)FACING));
                level.getCapability(CCCapabilities.FIELDS).ifPresent(fields -> fields.get(center).ifPresent(IMiniaturizationField::checkRedstone));
            });
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (FieldProjectorBlock.isActive(state)) {
            return new FieldProjectorEntity(pos, state);
        }
        return null;
    }
}

