/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.projector;

import dev.compactmods.crafting.api.field.MiniaturizationFieldSize;
import dev.compactmods.crafting.projector.FieldProjectorBlock;
import dev.compactmods.crafting.util.DirectionUtil;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class ProjectorHelper {
    public static Optional<MiniaturizationFieldSize> getClosestSize(BlockGetter level, BlockPos initial, Direction facing) {
        Optional<MiniaturizationFieldSize> opposing = ProjectorHelper.getClosestOppositeSize(level, initial, facing);
        if (opposing.isPresent()) {
            return opposing;
        }
        return ProjectorHelper.getSmallestCrossAxisSize(level, initial, facing);
    }

    public static Optional<MiniaturizationFieldSize> getClosestOppositeSize(BlockGetter level, BlockPos initial, Direction facing) {
        return Stream.of(MiniaturizationFieldSize.VALID_SIZES).filter(size -> {
            BlockPos oppPos = size.getOppositeProjectorPosition(initial, facing);
            BlockState oppState = level.m_8055_(oppPos);
            if (oppState.m_60734_() instanceof FieldProjectorBlock) {
                Direction f = (Direction)oppState.m_61143_((Property)FieldProjectorBlock.FACING);
                return f.m_122424_().equals((Object)facing);
            }
            return false;
        }).findFirst();
    }

    public static Optional<MiniaturizationFieldSize> getClosestOppositeSize(BlockGetter world, BlockPos initial) {
        for (MiniaturizationFieldSize size : MiniaturizationFieldSize.VALID_SIZES) {
            if (!ProjectorHelper.hasProjectorOpposite(world, initial, size)) continue;
            return Optional.of(size);
        }
        return Optional.empty();
    }

    public static boolean hasProjectorOpposite(BlockGetter world, BlockPos initial, MiniaturizationFieldSize size) {
        Direction oppFacing;
        Optional<Direction> initialFacing = FieldProjectorBlock.getDirection(world, initial);
        if (!initialFacing.isPresent()) {
            return false;
        }
        Direction initFacing = initialFacing.get();
        BlockPos oppositePos = size.getOppositeProjectorPosition(initial, initFacing);
        BlockState oppositeState = world.m_8055_(oppositePos);
        return oppositeState.m_60734_() instanceof FieldProjectorBlock && (oppFacing = (Direction)oppositeState.m_61143_((Property)FieldProjectorBlock.FACING)).m_122424_() == initFacing;
    }

    public static Stream<BlockPos> getValidOppositePositions(BlockPos initial, Direction facing) {
        return Stream.of(MiniaturizationFieldSize.VALID_SIZES).map(s -> s.getOppositeProjectorPosition(initial, facing));
    }

    public static boolean hasValidCrossProjector(BlockGetter world, BlockPos initialProjector, Direction projectorFacing, MiniaturizationFieldSize size) {
        Direction.Axis crossAxis = DirectionUtil.getCrossDirectionAxis(projectorFacing.m_122434_());
        BlockPos sizeCenter = size.getCenterFromProjector(initialProjector, projectorFacing);
        return size.getProjectorLocationsForAxis(sizeCenter, crossAxis).anyMatch(crossProjPos -> {
            BlockState crossProjState = world.m_8055_(crossProjPos);
            if (!(crossProjState.m_60734_() instanceof FieldProjectorBlock)) {
                return false;
            }
            Direction crossFacing = (Direction)crossProjState.m_61143_((Property)FieldProjectorBlock.FACING);
            BlockPos crossFacingCenter = size.getCenterFromProjector((BlockPos)crossProjPos, crossFacing);
            return crossFacingCenter.equals((Object)sizeCenter);
        });
    }

    public static Stream<BlockPos> getMissingProjectors(BlockGetter level, BlockPos initialProjector, Direction projectorFacing) {
        Optional<MiniaturizationFieldSize> fieldSize = ProjectorHelper.getClosestOppositeSize(level, initialProjector);
        if (fieldSize.isPresent()) {
            MiniaturizationFieldSize size = fieldSize.get();
            BlockPos center = size.getCenterFromProjector(initialProjector, projectorFacing);
            return ProjectorHelper.getMissingProjectors(level, size, center);
        }
        Optional<MiniaturizationFieldSize> firstMatchedSize = ProjectorHelper.getSmallestCrossAxisSize(level, initialProjector, projectorFacing);
        if (firstMatchedSize.isPresent()) {
            MiniaturizationFieldSize matchedSize = firstMatchedSize.get();
            BlockPos matchedCenter = matchedSize.getCenterFromProjector(initialProjector, projectorFacing);
            return ProjectorHelper.getMissingProjectors(level, matchedSize, matchedCenter);
        }
        return ProjectorHelper.getValidOppositePositions(initialProjector, projectorFacing);
    }

    @Nonnull
    private static Optional<MiniaturizationFieldSize> getSmallestCrossAxisSize(BlockGetter level, BlockPos initial, Direction facing) {
        return Stream.of(MiniaturizationFieldSize.VALID_SIZES).filter(size -> ProjectorHelper.hasValidCrossProjector(level, initial, facing, size)).findFirst();
    }

    @Nonnull
    public static Stream<BlockPos> getMissingProjectors(BlockGetter level, MiniaturizationFieldSize size, BlockPos center) {
        return size.getProjectorLocations(center).filter(proj -> !ProjectorHelper.projectorFacesCenter(level, proj, center, size));
    }

    public static boolean projectorFacesCenter(BlockGetter world, BlockPos proj, BlockPos actualCenter, MiniaturizationFieldSize size) {
        return FieldProjectorBlock.getDirection(world, proj).map(projFacing -> size.getCenterFromProjector(proj, (Direction)projFacing).equals((Object)actualCenter)).orElse(false);
    }
}

