/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.proxies.data;

import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.core.CCCapabilities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class BaseFieldProxyEntity
extends BlockEntity {
    @Nullable
    protected BlockPos fieldCenter;
    protected LazyOptional<IMiniaturizationField> field = LazyOptional.empty();

    public BaseFieldProxyEntity(BlockEntityType<? extends BaseFieldProxyEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.fieldCenter != null && this.f_58857_ != null) {
            this.f_58857_.getCapability(CCCapabilities.FIELDS).resolve().ifPresent(fields -> this.fieldChanged(fields.getLazy(this.fieldCenter)));
        }
    }

    public void updateField(BlockPos fieldCenter) {
        if (this.f_58857_ == null) {
            return;
        }
        if (fieldCenter == null) {
            this.field = LazyOptional.empty();
            this.fieldCenter = null;
            return;
        }
        this.f_58857_.getCapability(CCCapabilities.FIELDS).map(fields -> fields.getLazy(fieldCenter)).ifPresent(f -> {
            this.fieldCenter = fieldCenter;
            this.fieldChanged((LazyOptional<IMiniaturizationField>)f);
        });
    }

    protected void fieldChanged(LazyOptional<IMiniaturizationField> f) {
        this.field = f;
        f.addListener(lof -> {
            this.field = LazyOptional.empty();
            this.fieldCenter = null;
        });
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CCCapabilities.MINIATURIZATION_FIELD) {
            return this.field.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.field.ifPresent(field -> tag.m_128365_("center", (Tag)NbtUtils.m_129224_((BlockPos)field.getCenter())));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("center")) {
            this.fieldCenter = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("center"));
        }
    }
}

