/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.components;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.compactmods.crafting.api.components.RecipeComponentType;
import dev.compactmods.crafting.recipes.components.ComponentRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public final class RecipeComponentTypeCodec
implements Codec<RecipeComponentType<?>> {
    public static final RecipeComponentTypeCodec INSTANCE = new RecipeComponentTypeCodec();

    private RecipeComponentTypeCodec() {
    }

    public <T> DataResult<Pair<RecipeComponentType<?>, T>> decode(DynamicOps<T> ops, T input) {
        IForgeRegistry<RecipeComponentType<?>> reg = ComponentRegistration.COMPONENTS.get();
        return ResourceLocation.f_135803_.decode(ops, input).flatMap(rl -> {
            ResourceLocation resource = (ResourceLocation)rl.getFirst();
            if (reg.containsKey(resource)) {
                return DataResult.success((Object)rl.mapFirst(arg_0 -> ((IForgeRegistry)reg).getValue(arg_0)));
            }
            return DataResult.error((String)("Unknown registry key: " + rl.getFirst()));
        });
    }

    public <T> DataResult<T> encode(RecipeComponentType<?> input, DynamicOps<T> ops, T prefix) {
        ResourceLocation key = ComponentRegistration.COMPONENTS.get().getKey(input);
        if (key == null) {
            return DataResult.error((String)("Unknown registry element " + input));
        }
        Object toMerge = ops.createString(key.toString());
        return ops.mergeToPrimitive(prefix, toMerge);
    }
}

