/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.layers;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.api.components.IRecipeBlockComponent;
import dev.compactmods.crafting.api.components.IRecipeComponents;
import dev.compactmods.crafting.api.recipe.layers.IRecipeBlocks;
import dev.compactmods.crafting.api.recipe.layers.IRecipeLayer;
import dev.compactmods.crafting.api.recipe.layers.RecipeLayerType;
import dev.compactmods.crafting.api.recipe.layers.dim.IFixedSizedRecipeLayer;
import dev.compactmods.crafting.core.CCLayerTypes;
import dev.compactmods.crafting.recipes.blocks.ComponentPositionLookup;
import dev.compactmods.crafting.server.ServerConfig;
import dev.compactmods.crafting.util.BlockSpaceUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MixedComponentRecipeLayer
implements IRecipeLayer,
IFixedSizedRecipeLayer,
RecipeLayerType<MixedComponentRecipeLayer> {
    private final AABB dimensions;
    private final ComponentPositionLookup componentLookup;
    public static final Codec<MixedComponentRecipeLayer> CODEC = RecordCodecBuilder.create(i -> i.group((App)ComponentPositionLookup.CODEC.fieldOf("pattern").forGetter(MixedComponentRecipeLayer::getComponentLookup)).apply((Applicative)i, MixedComponentRecipeLayer::new));

    public MixedComponentRecipeLayer() {
        this.dimensions = AABB.m_165882_((Vec3)Vec3.f_82478_, (double)0.0, (double)0.0, (double)0.0);
        this.componentLookup = new ComponentPositionLookup();
    }

    public MixedComponentRecipeLayer(ComponentPositionLookup components) {
        this.componentLookup = components;
        this.dimensions = BlockSpaceUtil.getBoundsForBlocks(this.componentLookup.getAllPositions());
    }

    public ComponentPositionLookup getComponentLookup() {
        return this.componentLookup;
    }

    @Override
    public AABB getDimensions() {
        return this.dimensions;
    }

    @Override
    public Set<String> getComponents() {
        return ImmutableSet.copyOf(this.componentLookup.getComponents());
    }

    @Override
    public void dropNonRequiredComponents(IRecipeComponents components) {
        components.getEmptyComponents().forEach(this.componentLookup::remove);
        Set<String> definedKeys = components.getBlockComponents().keySet();
        Set<String> toRemove = this.componentLookup.getComponents().stream().filter(layerComp -> !definedKeys.contains(layerComp)).collect(Collectors.toSet());
        CompactCrafting.RECIPE_LOGGER.debug("Removing {} from required component list; it was not defined in the recipe.", (Object)String.join((CharSequence)",", toRemove));
        toRemove.forEach(this.componentLookup::remove);
    }

    @Override
    public Map<String, Integer> getComponentTotals() {
        return this.componentLookup.getComponentTotals();
    }

    @Override
    public Optional<String> getComponentForPosition(BlockPos pos) {
        return this.componentLookup.getRequiredComponentKeyForPosition(pos);
    }

    @Override
    public Stream<BlockPos> getPositionsForComponent(String component) {
        return this.componentLookup.getPositionsForComponent(component);
    }

    public int getNumberFilledPositions() {
        return this.getComponentTotals().values().stream().reduce(0, Integer::sum);
    }

    @Override
    public boolean matches(IRecipeComponents components, IRecipeBlocks blocks) {
        if (!blocks.allIdentified()) {
            boolean anyNonAir = blocks.getUnmappedPositions().map(blocks::getStateAtPosition).anyMatch(state -> !state.m_60795_());
            if (anyNonAir) {
                return false;
            }
        }
        Collection<String> requiredKeys = this.componentLookup.getComponents();
        Map<String, Integer> componentTotals = blocks.getKnownComponentTotals();
        Set missingRequired = requiredKeys.stream().filter(rk -> !componentTotals.containsKey(rk)).collect(Collectors.toSet());
        if (!missingRequired.isEmpty()) {
            if (((Boolean)ServerConfig.RECIPE_MATCHING.get()).booleanValue()) {
                CompactCrafting.RECIPE_LOGGER.debug("Failed to match: required components ({}) are missing.", (Object)String.join((CharSequence)",", missingRequired));
            }
            return false;
        }
        for (String required : requiredKeys) {
            IRecipeBlockComponent block = components.getBlock(required).orElse(null);
            Set actual = blocks.getPositionsForComponent(required).map(BlockPos::m_7949_).collect(Collectors.toSet());
            Set expected = this.componentLookup.getPositionsForComponent(required).map(BlockPos::m_7949_).collect(Collectors.toSet());
            if (expected.equals(actual)) continue;
            if (((Boolean)ServerConfig.RECIPE_MATCHING.get()).booleanValue()) {
                CompactCrafting.RECIPE_LOGGER.debug("Failed to match: required components are missing or in incorrect spots.");
            }
            return false;
        }
        return true;
    }

    @Override
    public RecipeLayerType<?> getType() {
        return (RecipeLayerType)CCLayerTypes.MIXED_LAYER_TYPE.get();
    }

    @Override
    public Codec<MixedComponentRecipeLayer> getCodec() {
        return CODEC;
    }
}

