/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.server;

import com.electronwill.nightconfig.core.EnumGetMethod;
import dev.compactmods.crafting.api.FieldDestabilizeHandling;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="compactcrafting", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ServerConfig {
    public static ForgeConfigSpec CONFIG;
    public static ForgeConfigSpec.BooleanValue RECIPE_REGISTRATION;
    public static ForgeConfigSpec.BooleanValue FIELD_BLOCK_CHANGES;
    public static ForgeConfigSpec.BooleanValue RECIPE_MATCHING;
    private static ForgeConfigSpec.EnumValue<FieldDestabilizeHandling> FIELD_DESTABILIZE_HANDLING;
    public static FieldDestabilizeHandling DESTABILIZE_HANDLING;

    private static void generateConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Logging Settings").push("logging");
        RECIPE_REGISTRATION = builder.comment("Enables more logging during recipe registration and syncing.").define("recipeRegistration", false);
        FIELD_BLOCK_CHANGES = builder.comment("Enables more logging for fields handling nearby block updates.").define("fieldBlockChanges", false);
        RECIPE_MATCHING = builder.comment("Enables more logging for the recipe matching process.").define("recipeMatching", false);
        builder.pop();
        builder.comment("Field Settings").push("field");
        FIELD_DESTABILIZE_HANDLING = builder.comment("Changes how the field handles a destabilization event (such as a projector breaking mid-craft)").defineEnum("destabilizeHandling", (Enum)FieldDestabilizeHandling.RESTORE_ALL, EnumGetMethod.NAME_IGNORECASE);
        builder.pop();
        CONFIG = builder.build();
    }

    @SubscribeEvent
    public static void onConfigEvent(ModConfigEvent.Reloading configEvent) {
        DESTABILIZE_HANDLING = (FieldDestabilizeHandling)((Object)FIELD_DESTABILIZE_HANDLING.get());
    }

    static {
        DESTABILIZE_HANDLING = FieldDestabilizeHandling.RESTORE_ALL;
        ServerConfig.generateConfig();
    }
}

