/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel;

import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.TunnelPosition;
import dev.compactmods.machines.api.tunnels.lifecycle.TunnelTeardownHandler;
import dev.compactmods.machines.dimension.Dimension;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.tunnel.TunnelHelper;
import dev.compactmods.machines.tunnel.TunnelWallEntity;
import dev.compactmods.machines.tunnel.Tunnels;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import dev.compactmods.machines.wall.ProtectedWallBlock;
import dev.compactmods.machines.wall.Walls;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TunnelWallBlock
extends ProtectedWallBlock
implements EntityBlock {
    public static final DirectionProperty TUNNEL_SIDE = DirectionProperty.m_61549_((String)"tunnel_side", (Direction[])Direction.values());
    public static final DirectionProperty CONNECTED_SIDE = DirectionProperty.m_61549_((String)"connected_side", (Direction[])Direction.values());
    public static final BooleanProperty REDSTONE = BooleanProperty.m_61465_((String)"redstone");

    public TunnelWallBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)CONNECTED_SIDE, (Comparable)Direction.UP)).m_61124_((Property)TUNNEL_SIDE, (Comparable)Direction.UP)).m_61124_((Property)REDSTONE, (Comparable)Boolean.valueOf(false)));
    }

    public static Optional<TunnelDefinition> getTunnelInfo(BlockGetter world, BlockPos position) {
        TunnelWallEntity tile = (TunnelWallEntity)world.m_7702_(position);
        if (tile == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(tile.getTunnelType());
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos position, @Nullable Direction side) {
        return (Boolean)state.m_61143_((Property)REDSTONE);
    }

    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)REDSTONE);
    }

    public int m_6376_(BlockState state, BlockGetter world, BlockPos position, Direction side) {
        return 0;
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos position, Direction side) {
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TUNNEL_SIDE}).m_61104_(new Property[]{CONNECTED_SIDE}).m_61104_(new Property[]{REDSTONE});
        super.m_7926_(builder);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TunnelWallEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof TunnelWallEntity)) {
            return InteractionResult.FAIL;
        }
        TunnelWallEntity tunnel = (TunnelWallEntity)blockEntity;
        if (level.m_46472_().equals(Dimension.COMPACT_DIMENSION) && level instanceof ServerLevel) {
            ServerLevel compactDim = (ServerLevel)level;
            TunnelDefinition def = tunnel.getTunnelType();
            Direction tunnelWallSide = hitResult.m_82434_();
            if (player.m_6144_()) {
                BlockState solidWall = ((Block)Walls.BLOCK_SOLID_WALL.get()).m_49966_();
                level.m_46597_(pos, solidWall);
                ItemStack stack = new ItemStack((ItemLike)Tunnels.ITEM_TUNNEL.get(), 1);
                CompoundTag defTag = stack.m_41698_("definition");
                defTag.m_128359_("id", Tunnels.getRegistryId(def).toString());
                ItemEntity ie = new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                level.m_7967_((Entity)ie);
                if (def instanceof TunnelTeardownHandler) {
                    TunnelTeardownHandler teardown = (TunnelTeardownHandler)((Object)def);
                    teardown.onRemoved(new TunnelPosition(compactDim, pos, tunnelWallSide), tunnel.getTunnel());
                }
                TunnelConnectionGraph tunnels = TunnelConnectionGraph.forRoom(compactDim, new ChunkPos(pos));
                tunnels.unregister(pos);
            } else {
                Direction dir = (Direction)state.m_61143_((Property)CONNECTED_SIDE);
                TunnelConnectionGraph tunnelGraph = TunnelConnectionGraph.forRoom(compactDim, new ChunkPos(pos));
                Set<Direction> existingDirs = tunnelGraph.getTunnelSides(def).collect(Collectors.toSet());
                if (existingDirs.size() == 6) {
                    player.m_5661_((Component)TranslationUtil.message(Messages.NO_TUNNEL_SIDE).m_130940_(ChatFormatting.DARK_RED), true);
                    return InteractionResult.FAIL;
                }
                Optional<Direction> next = TunnelHelper.getNextDirection(dir, existingDirs);
                next.ifPresent(newSide -> {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)CONNECTED_SIDE, (Comparable)newSide));
                    if (def instanceof TunnelTeardownHandler) {
                        TunnelTeardownHandler teardown = (TunnelTeardownHandler)((Object)def);
                        teardown.onRotated(new TunnelPosition(compactDim, pos, tunnelWallSide), tunnel.getTunnel(), dir, (Direction)newSide);
                    }
                    tunnelGraph.rotateTunnel(pos, (Direction)newSide);
                    tunnelGraph.m_77762_();
                });
            }
        }
        return InteractionResult.SUCCESS;
    }
}

