/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.upgrade;

import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.room.upgrade.RoomUpgrade;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeInstance;
import dev.compactmods.machines.graph.IGraphEdge;
import dev.compactmods.machines.graph.IGraphNode;
import dev.compactmods.machines.room.graph.CompactMachineRoomNode;
import dev.compactmods.machines.upgrade.MachineRoomUpgrades;
import dev.compactmods.machines.upgrade.graph.RoomUpgradeConnection;
import dev.compactmods.machines.upgrade.graph.RoomUpgradeGraphNode;
import dev.compactmods.machines.upgrade.graph.UpgradeConnectionEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

public class RoomUpgradeManager
extends SavedData {
    public static final String DATA_NAME = "compactmachines_upgrades";
    private final HashMap<ResourceLocation, RoomUpgradeGraphNode> upgradeNodes = new HashMap();
    private final HashMap<ChunkPos, CompactMachineRoomNode> roomNodes = new HashMap();
    private final MutableValueGraph<IGraphNode, IGraphEdge> graph = ValueGraphBuilder.directed().build();
    private static final Codec<List<UpgradeConnectionEntry>> UPGRADE_CONNECTIONS_CODEC = UpgradeConnectionEntry.CODEC.listOf();

    private RoomUpgradeManager() {
    }

    @Nonnull
    public static RoomUpgradeManager get(ServerLevel level) {
        DimensionDataStorage sd = level.m_8895_();
        return (RoomUpgradeManager)sd.m_164861_(RoomUpgradeManager::fromNbt, RoomUpgradeManager::new, DATA_NAME);
    }

    private static RoomUpgradeManager fromNbt(CompoundTag tag) {
        RoomUpgradeManager inst = new RoomUpgradeManager();
        if (tag.m_128441_("upgrades")) {
            List upgrades = (List)UPGRADE_CONNECTIONS_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128437_("upgrades", 10)).getOrThrow(true, arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
            upgrades.forEach(conn -> {
                ChunkPos room = conn.room();
                Object data = conn.instance();
                if (!inst.addUpgrade(data, room)) {
                    CompactMachines.LOGGER.warn("Failed to load room upgrade for room {}: {}", (Object)room, (Object)conn.upgradeKey().toString());
                }
            });
        }
        return inst;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        if (!this.roomNodes.isEmpty() || !this.upgradeNodes.isEmpty()) {
            IForgeRegistry<RoomUpgrade> upgReg = MachineRoomUpgrades.REGISTRY.get();
            ArrayList upgradeList = new ArrayList();
            for (RoomUpgradeGraphNode upg : this.upgradeNodes.values()) {
                ResourceLocation id = upg.key();
                RoomUpgrade upgradeInst = (RoomUpgrade)upgReg.getValue(id);
                ResourceKey uKey = ResourceKey.m_135785_(RoomUpgrade.REG_KEY, (ResourceLocation)id);
                this.roomsWith((ResourceKey<RoomUpgrade>)uKey).forEach(room -> upgradeList.add(new UpgradeConnectionEntry<RoomUpgrade>((ChunkPos)room, (ResourceKey<RoomUpgrade>)uKey, upgradeInst)));
            }
            if (!upgradeList.isEmpty()) {
                Tag upgrades = (Tag)UPGRADE_CONNECTIONS_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, upgradeList).getOrThrow(true, arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
                tag.m_128365_("upgrades", upgrades);
            }
        }
        return tag;
    }

    public <T extends RoomUpgrade> boolean addUpgrade(T upgrade, ChunkPos room) {
        IForgeRegistry<RoomUpgrade> upgRegistry = MachineRoomUpgrades.REGISTRY.get();
        RoomUpgradeGraphNode upgradeNode = this.upgradeNodes.computeIfAbsent(upgRegistry.getKey(upgrade), rl -> {
            RoomUpgradeGraphNode node = new RoomUpgradeGraphNode((ResourceLocation)rl);
            return this.graph.addNode((Object)node) ? node : null;
        });
        CompactMachineRoomNode roomNode = this.roomNodes.computeIfAbsent(room, p -> {
            CompactMachineRoomNode nn = new CompactMachineRoomNode((ChunkPos)p);
            return this.graph.addNode((Object)nn) ? nn : null;
        });
        if (upgradeNode == null || roomNode == null) {
            return false;
        }
        this.graph.putEdgeValue((Object)roomNode, (Object)upgradeNode, new RoomUpgradeConnection<T>(upgrade));
        this.m_77762_();
        return true;
    }

    public <T extends RoomUpgrade> boolean removeUpgrade(T upgrade, ChunkPos room) {
        IForgeRegistry<RoomUpgrade> upgRegistry = MachineRoomUpgrades.REGISTRY.get();
        if (!upgRegistry.containsValue(upgrade)) {
            return false;
        }
        ResourceLocation upgId = upgRegistry.getKey(upgrade);
        if (!this.upgradeNodes.containsKey(upgId)) {
            return true;
        }
        if (!this.roomNodes.containsKey(room)) {
            return true;
        }
        RoomUpgradeGraphNode uNode = this.upgradeNodes.get(upgId);
        CompactMachineRoomNode rNode = this.roomNodes.get(room);
        this.graph.removeEdge((Object)rNode, (Object)uNode);
        this.m_77762_();
        return true;
    }

    public Stream<ChunkPos> roomsWith(ResourceKey<RoomUpgrade> upgradeKey) {
        if (!this.upgradeNodes.containsKey(upgradeKey.m_135782_())) {
            return Stream.empty();
        }
        return this.upgradeNodes.values().stream().filter(upg -> upg.key().equals((Object)upgradeKey.m_135782_())).flatMap(upg -> this.graph.adjacentNodes(upg).stream()).filter(CompactMachineRoomNode.class::isInstance).map(CompactMachineRoomNode.class::cast).map(CompactMachineRoomNode::pos);
    }

    public <T extends RoomUpgrade> Stream<RoomUpgradeInstance<T>> implementing(Class<T> inter) {
        IForgeRegistry<RoomUpgrade> upgRegistry = MachineRoomUpgrades.REGISTRY.get();
        Set matchedUpgrades = upgRegistry.getValues().stream().filter(inter::isInstance).map(arg_0 -> upgRegistry.getKey(arg_0)).collect(Collectors.toSet());
        Set matchedUpgradeNodes = this.upgradeNodes.values().stream().filter(upg -> matchedUpgrades.contains(upg.key())).collect(Collectors.toSet());
        HashSet instances = new HashSet();
        HashSet roomNodes = new HashSet();
        for (RoomUpgradeGraphNode upgNode : matchedUpgradeNodes) {
            for (IGraphNode adjNode : this.graph.adjacentNodes((Object)upgNode)) {
                if (!(adjNode instanceof CompactMachineRoomNode)) continue;
                CompactMachineRoomNode roomNode = (CompactMachineRoomNode)adjNode;
                this.graph.edgeValue((Object)roomNode, (Object)upgNode).ifPresent(edv -> {
                    RoomUpgradeConnection conn;
                    if (edv instanceof RoomUpgradeConnection && inter.isInstance((conn = (RoomUpgradeConnection)edv).instance())) {
                        instances.add(new RoomUpgradeInstance<RoomUpgrade>((RoomUpgrade)inter.cast(conn.instance()), roomNode.pos()));
                    }
                });
            }
        }
        return instances.stream();
    }

    public boolean hasUpgrade(ChunkPos room, RoomUpgrade upgrade) {
        IForgeRegistry<RoomUpgrade> upgRegistry = MachineRoomUpgrades.REGISTRY.get();
        if (!upgRegistry.containsValue((Object)upgrade)) {
            return false;
        }
        ResourceLocation upgId = upgRegistry.getKey((Object)upgrade);
        if (!this.upgradeNodes.containsKey(upgId)) {
            return false;
        }
        if (!this.roomNodes.containsKey(room)) {
            return false;
        }
        RoomUpgradeGraphNode upgNode = this.upgradeNodes.get(upgId);
        CompactMachineRoomNode roomNode = this.roomNodes.get(room);
        return this.graph.hasEdgeConnecting((Object)roomNode, (Object)upgNode);
    }
}

