/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.client.Client;
import tfar.dankstorage.client.DankTooltip;
import tfar.dankstorage.container.PortableDankProvider;
import tfar.dankstorage.item.DankItemCapability;
import tfar.dankstorage.mixin.ItemUsageContextAccessor;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.server.C2SRequestContentsPacket;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.PickupMode;
import tfar.dankstorage.utils.Utils;
import tfar.dankstorage.world.ClientData;
import tfar.dankstorage.world.DankInventory;
import tfar.dankstorage.world.DankSavedData;

public class DankItem
extends Item {
    public final DankStats stats;
    public static final Rarity DARK_GRAY = Rarity.create((String)"dark_gray", (ChatFormatting)ChatFormatting.DARK_GRAY);
    public static final Rarity DARK_RED = Rarity.create((String)"dark_red", (ChatFormatting)ChatFormatting.DARK_RED);
    public static final Rarity GOLD = Rarity.create((String)"gold", (ChatFormatting)ChatFormatting.GOLD);
    public static final Rarity GREEN = Rarity.create((String)"green", (ChatFormatting)ChatFormatting.GREEN);
    public static final Rarity BLUE = Rarity.create((String)"blue", (ChatFormatting)ChatFormatting.AQUA);
    public static final Rarity DARK_PURPLE = Rarity.create((String)"dark_purple", (ChatFormatting)ChatFormatting.DARK_PURPLE);
    public static final Rarity WHITE = Rarity.create((String)"white", (ChatFormatting)ChatFormatting.WHITE);
    private static final ThreadLocal<Integer> cache = ThreadLocal.withInitial(() -> -1);

    public DankItem(Item.Properties p_i48527_2_, DankStats stats) {
        super(p_i48527_2_);
        this.stats = stats;
    }

    @Nonnull
    public Rarity m_41460_(ItemStack stack) {
        return switch (this.stats) {
            case DankStats.one -> DARK_GRAY;
            case DankStats.two -> DARK_RED;
            case DankStats.three -> GOLD;
            case DankStats.four -> GREEN;
            case DankStats.five -> BLUE;
            case DankStats.six -> DARK_PURPLE;
            case DankStats.seven -> WHITE;
            default -> super.m_41460_(stack);
        };
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack bag = player.m_21120_(hand);
        if (Utils.getUseType(bag) == Utils.UseType.bag) {
            if (!level.f_46443_) {
                DankItem.assignNextId(bag);
                player.m_5893_((MenuProvider)new PortableDankProvider(bag));
            }
            return InteractionResultHolder.m_19090_((Object)bag);
        }
        if (!level.f_46443_) {
            EquipmentSlot hand1;
            ItemStack toPlace = Utils.getItemStackInSelectedSlot(bag, (ServerLevel)level);
            EquipmentSlot equipmentSlot = hand1 = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            if (toPlace.m_41619_()) {
                return InteractionResultHolder.m_19098_((Object)bag);
            }
            if (toPlace.m_41720_().m_41472_()) {
                if (player.m_36391_(false)) {
                    player.m_6672_(hand);
                    return InteractionResultHolder.m_19096_((Object)bag);
                }
            } else {
                if (toPlace.m_41720_() instanceof PotionItem) {
                    player.m_6672_(hand);
                    return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
                }
                if (toPlace.m_41720_() instanceof ShieldItem) {
                    player.m_6672_(hand);
                    return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
                }
                ItemStack bagCopy = bag.m_41777_();
                player.m_8061_(hand1, toPlace);
                InteractionResultHolder actionResult = toPlace.m_41720_().m_7203_(level, player, hand);
                DankInventory handler = Utils.getOrCreateInventory(bagCopy, level);
                handler.setStackInSlot(Utils.getSelectedSlot(bagCopy), (ItemStack)actionResult.m_19095_());
                player.m_8061_(hand1, bagCopy);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    public InteractionResult m_6880_(ItemStack bag, Player player, LivingEntity entity, InteractionHand hand) {
        if (!Utils.isConstruction(bag)) {
            return InteractionResult.PASS;
        }
        ItemStack toUse = Utils.getSelectedItem(bag, player.f_19853_);
        EquipmentSlot hand1 = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        player.m_8061_(hand1, toUse);
        InteractionResult result = toUse.m_41720_().m_6880_(toUse, player, entity, hand);
        if (!player.f_19853_.f_46443_) {
            DankInventory handler = Utils.getOrCreateInventory(bag, player.f_19853_);
            handler.setStackInSlot(Utils.getSelectedSlot(bag), toUse);
        }
        player.m_8061_(hand1, bag);
        return result;
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_() && Utils.getPickupMode(stack) != PickupMode.none;
    }

    public void m_7373_(ItemStack bag, @javax.annotation.Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (bag.m_41782_() && Utils.DEV) {
            String s = bag.m_41783_().toString();
            ArrayList<String> bits = new ArrayList<String>();
            int length = s.length();
            if (s.length() > 10000) {
                return;
            }
            int itr = (int)Math.ceil((double)length / 40.0);
            for (int i = 0; i < itr; ++i) {
                int end = (i + 1) * 40;
                if ((i + 1) * 40 - 1 >= length) {
                    end = length;
                }
                String s12 = s.substring(i * 40, end);
                bits.add(s12);
            }
            bits.forEach(s1 -> tooltip.add((Component)Utils.literal(s1)));
        }
        int id = Utils.getFrequency(bag);
        tooltip.add((Component)Utils.literal("ID: " + id));
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Utils.translatable("text.dankstorage.shift", Utils.literal("Shift").m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Utils.translatable("text.dankstorage.change_pickup_mode", Client.PICKUP_MODE.m_90863_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY));
            PickupMode pickupMode = Utils.getPickupMode(bag);
            tooltip.add((Component)Utils.translatable("text.dankstorage.current_pickup_mode", Utils.translatable("dankstorage.mode." + pickupMode.name().toLowerCase(Locale.ROOT)).m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Utils.translatable("text.dankstorage.changeusetype", Client.CONSTRUCTION.m_90863_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY));
            Utils.UseType useType = Utils.getUseType(bag);
            tooltip.add((Component)Utils.translatable("text.dankstorage.currentusetype", Utils.translatable("dankstorage.usetype." + useType.name().toLowerCase(Locale.ROOT)).m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Utils.translatable("text.dankstorage.stacklimit", Utils.literal("" + this.stats.stacklimit).m_130940_(ChatFormatting.GREEN)).m_130940_(ChatFormatting.GRAY));
        }
    }

    public int getGlintColor(ItemStack stack) {
        PickupMode pickupMode = Utils.getPickupMode(stack);
        switch (pickupMode) {
            default: {
                return -1;
            }
            case pickup_all: {
                return -16711936;
            }
            case filtered_pickup: {
                return -256;
            }
            case void_pickup: 
        }
        return -65536;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack bag = ctx.m_43722_();
        Level level = ctx.m_43725_();
        Utils.UseType useType = Utils.getUseType(bag);
        if (useType == Utils.UseType.bag) {
            return InteractionResult.PASS;
        }
        int selectedSlot = Utils.getSelectedSlot(bag);
        if (selectedSlot == -1) {
            return InteractionResult.PASS;
        }
        ItemStack toPlace = Utils.getSelectedItem(bag, level);
        ItemUseContextExt ctx2 = new ItemUseContextExt(ctx.m_43725_(), ctx.m_43723_(), ctx.m_43724_(), toPlace, ((ItemUsageContextAccessor)ctx).getHitResult());
        InteractionResult actionResultType = toPlace.m_41720_().m_6225_((UseOnContext)ctx2);
        if (!level.f_46443_) {
            DankInventory dankInventory = Utils.getInventory(bag, level);
            dankInventory.setStackInSlot(selectedSlot, ctx2.m_43722_());
        }
        return actionResultType;
    }

    public void m_6883_(ItemStack bag, Level level, Entity entity, int i, boolean equipped) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (equipped) {
                ItemStack sel = Utils.getSelectedItem(bag, level);
                DankPacketHandler.sendSelectedItem(player, sel);
            }
        }
    }

    public boolean m_41386_(DamageSource source) {
        return source == DamageSource.f_19317_;
    }

    public static void assignNextId(ItemStack dank) {
        CompoundTag settings = Utils.getSettings(dank);
        if (settings == null || !settings.m_128425_("dankstorage:id", 3)) {
            DankSavedData dankSavedData = DankStorage.instance.data;
            DankStats stats = Utils.getStats(dank);
            int next = dankSavedData.getNextID();
            dankSavedData.getOrCreateInventory(next, stats);
            Utils.getOrCreateSettings(dank).m_128405_("dankstorage:id", next);
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack itemStack) {
        int id = Utils.getFrequency(itemStack);
        if (id > -1) {
            C2SRequestContentsPacket.send(id);
            cache.set(id);
            if (ClientData.cachedItems != null) {
                return Optional.of(new DankTooltip(ClientData.cachedItems, Utils.getSelectedSlot(itemStack)));
            }
        }
        return Optional.empty();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (Utils.getFrequency(stack) != -1) {
            return new DankItemCapability(stack);
        }
        return super.initCapabilities(stack, nbt);
    }

    public static class ItemUseContextExt
    extends UseOnContext {
        protected ItemUseContextExt(Level level, @javax.annotation.Nullable Player player, InteractionHand hand, ItemStack stack, BlockHitResult result) {
            super(level, player, hand, stack, result);
        }
    }
}

