/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.deepcustomization.overlay.progressbar;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.mixin.mixins.client.IMixinLoadingOverlay;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationElement;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationItem;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class OverlayProgressBarItem
extends DeepCustomizationItem {
    public String hexColorString = "#RRGGBB";
    public Color hexColor = null;
    public boolean useOriginalSizeAndPosCalculation = true;

    public OverlayProgressBarItem(DeepCustomizationElement parentElement, PropertiesSection item) {
        super(parentElement, item);
        String oriPosSizeCalc;
        Color c;
        String hex = item.getEntryValue("custom_color_hex");
        if (hex != null && !hex.toUpperCase().replace(" ", "").equals("#RRGGBB") && !hex.replace(" ", "").equals("") && (c = RenderUtils.getColorFromHexString((String)hex)) != null) {
            this.hexColorString = hex;
            this.hexColor = c;
        }
        if ((oriPosSizeCalc = item.getEntryValue("original_pos_size_calculation")) != null && oriPosSizeCalc.equals("false")) {
            this.useOriginalSizeAndPosCalculation = false;
        }
    }

    public void render(PoseStack matrix, Screen menu) {
        Minecraft mc = Minecraft.m_91087_();
        int i = mc.m_91268_().m_85445_();
        double d1 = Math.min((double)mc.m_91268_().m_85445_() * 0.75, (double)mc.m_91268_().m_85446_()) * 0.25;
        double d0 = d1 * 4.0;
        int j1 = (int)(d0 * 0.5);
        int k1 = (int)((double)mc.m_91268_().m_85446_() * 0.8325);
        float currentProgress = 0.5f;
        if (!OverlayProgressBarItem.isEditorActive() && Minecraft.m_91087_().m_91265_() != null && Minecraft.m_91087_().m_91265_() instanceof LoadingOverlay) {
            currentProgress = ((IMixinLoadingOverlay)Minecraft.m_91087_().m_91265_()).getCurrentProgressDrippy();
        }
        int posX = i / 2 - j1;
        int posY = k1 - 5;
        int w = j1 * 2;
        int h = 10;
        if (this.useOriginalSizeAndPosCalculation) {
            this.posX = posX;
            this.posY = posY;
            this.width = w;
            this.height = h;
            this.orientation = "top-left";
        } else {
            posX = this.getPosX(menu);
            posY = this.getPosY(menu);
            w = this.getWidth();
            h = this.getHeight();
        }
        if (this.shouldRender()) {
            this.drawProgressBar(matrix, posX, posY, posX + w, posY + h, this.opacity, currentProgress);
        }
    }

    public boolean shouldRender() {
        return super.shouldRender() && !this.hidden;
    }

    private void drawProgressBar(PoseStack matrix, int xMin, int yMin, int xMax, int yMax, float opacity, float currentProgress) {
        int i = Mth.m_14167_((float)((float)(xMax - xMin - 2) * currentProgress));
        int j = Math.round(opacity * 255.0f);
        int k = FastColor.ARGB32.m_13660_((int)j, (int)255, (int)255, (int)255);
        if (this.hexColor != null) {
            k = FastColor.ARGB32.m_13660_((int)j, (int)this.hexColor.getRed(), (int)this.hexColor.getGreen(), (int)this.hexColor.getBlue());
        }
        OverlayProgressBarItem.m_93172_((PoseStack)matrix, (int)(xMin + 2), (int)(yMin + 2), (int)(xMin + i), (int)(yMax - 2), (int)k);
        OverlayProgressBarItem.m_93172_((PoseStack)matrix, (int)(xMin + 1), (int)yMin, (int)(xMax - 1), (int)(yMin + 1), (int)k);
        OverlayProgressBarItem.m_93172_((PoseStack)matrix, (int)(xMin + 1), (int)yMax, (int)(xMax - 1), (int)(yMax - 1), (int)k);
        OverlayProgressBarItem.m_93172_((PoseStack)matrix, (int)xMin, (int)yMin, (int)(xMin + 1), (int)yMax, (int)k);
        OverlayProgressBarItem.m_93172_((PoseStack)matrix, (int)xMax, (int)yMin, (int)(xMax - 1), (int)yMax, (int)k);
    }
}

