/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.embeddiumplus;

import com.jozufozu.flywheel.config.BackendType;
import com.jozufozu.flywheel.config.FlwConfig;
import it.unimi.dsi.fastutil.longs.LongLongMutablePair;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import me.srrapero720.embeddiumplus.EmbeddiumPlus;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLLoader;

public class EmbyTools {
    private static final LongLongPair[] BENCHTIMES = new LongLongPair[100];
    private static int BENCH_POS = 0;

    public static <T> T getLastValue(T[] value) {
        return value[value.length - 1];
    }

    public static boolean canUseFastChests() {
        try {
            return FlwConfig.get().getBackendType() == BackendType.OFF;
        }
        catch (Error e) {
            return true;
        }
    }

    public static void benchStart() {
        EmbyTools.BENCHTIMES[EmbyTools.BENCH_POS] = new LongLongMutablePair(Util.m_137569_(), -1L);
    }

    public static void benchEnd() {
        BENCHTIMES[BENCH_POS].right(Util.m_137569_());
        EmbeddiumPlus.LOGGER.debug("Current method takes RIGHT NOW {} nanoseconds", (Object)(BENCHTIMES[BENCH_POS].rightLong() - BENCHTIMES[BENCH_POS].leftLong()));
        if (BENCH_POS == BENCHTIMES.length - 1) {
            long totalStart = 0L;
            long totalEnd = 0L;
            for (int i = 0; i < BENCHTIMES.length; ++i) {
                totalStart += BENCHTIMES[i].firstLong();
                totalEnd += BENCHTIMES[i].secondLong();
            }
            EmbeddiumPlus.LOGGER.info("Current method takes AVG {} nanoseconds", (Object)((totalEnd - totalStart) / (long)BENCHTIMES.length));
            BENCH_POS = 0;
        } else {
            ++BENCH_POS;
        }
    }

    public static ChatFormatting colorByLow(int usage) {
        return usage < 9 ? ChatFormatting.DARK_RED : (usage < 16 ? ChatFormatting.RED : (usage < 30 ? ChatFormatting.GOLD : ChatFormatting.RESET));
    }

    public static ChatFormatting colorByPercent(int usage) {
        return usage >= 100 ? ChatFormatting.DARK_RED : (usage >= 90 ? ChatFormatting.RED : (usage >= 75 ? ChatFormatting.GOLD : ChatFormatting.RESET));
    }

    public static String tintByLower(int usage) {
        return (usage < 9 ? ChatFormatting.DARK_RED : (usage < 16 ? ChatFormatting.RED : (usage < 30 ? ChatFormatting.GOLD : ChatFormatting.RESET))).toString() + usage;
    }

    public static String tintByPercent(long usage) {
        return (usage >= 100L ? ChatFormatting.DARK_RED : (usage >= 90L ? ChatFormatting.RED : (usage >= 75L ? ChatFormatting.GOLD : ChatFormatting.RESET))).toString() + usage;
    }

    public static int getColorARGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static long ramUsed() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long bytesToMB(long input) {
        return input / 1024L / 1024L;
    }

    public static boolean isModInstalled(String modid) {
        return FMLLoader.getLoadingModList().getModFileById(modid) != null;
    }

    public static boolean isEntityWithinDistance(Player player, Entity entity, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(player.m_20186_() - entity.m_20186_() - 4.0) < (double)maxHeight) {
            double z;
            double x = player.m_20185_() - entity.m_20185_();
            return x * x + (z = player.m_20189_() - entity.m_20189_()) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(BlockPos bePos, Vec3 camVec, int maxHeight, int maxDistanceSquare) {
        if (Math.abs((double)bePos.m_123342_() - camVec.f_82480_ - 4.0) < (double)maxHeight) {
            double z;
            double x = (double)bePos.m_123341_() - camVec.f_82479_;
            return x * x + (z = (double)bePos.m_123343_() - camVec.f_82481_) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(Entity entity, double cameraX, double cameraY, double cameraZ, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(entity.m_20186_() - cameraY - 4.0) < (double)maxHeight) {
            double z;
            double x = entity.m_20185_() - cameraX;
            return x * x + (z = entity.m_20189_() - cameraZ) * z < (double)maxDistanceSquare;
        }
        return false;
    }
}

