/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.embeddiumplus.foundation.dynlights;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import me.srrapero720.embeddiumplus.EmbyConfig;
import me.srrapero720.embeddiumplus.foundation.dynlights.DynLightsHandlers;
import me.srrapero720.embeddiumplus.foundation.dynlights.accessors.DynamicLightSource;
import me.srrapero720.embeddiumplus.foundation.dynlights.item.ItemLightRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class DynLightsPlus {
    private static final Marker IT = MarkerManager.getMarker((String)"DynamicLights");
    private static final double MAX_RADIUS = 12.0;
    private static final double MAX_RADIUS_SQUARED = 144.0;
    private static final DynLightsPlus INSTANCE = new DynLightsPlus();
    private final Set<DynamicLightSource> dynamicLightSources = new HashSet<DynamicLightSource>();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    private long lastUpdate = System.currentTimeMillis();
    private int lastUpdateCount = 0;
    private static long lastUpdateTime = 0L;

    public static void init() {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        if (resourceManager instanceof ReloadableResourceManager) {
            ReloadableResourceManager reloadableResourceManager = (ReloadableResourceManager)resourceManager;
            reloadableResourceManager.m_7217_((PreparableReloadListener)((ResourceManagerReloadListener)ItemLightRegistry::load));
        }
        DynLightsHandlers.registerDefaultHandlers(null);
    }

    public static boolean isEnabled() {
        return EmbyConfig.dynLightSpeed.get() != EmbyConfig.DynLightsSpeed.OFF;
    }

    public void updateAll(@NotNull LevelRenderer renderer) {
        if (!DynLightsPlus.isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= this.lastUpdate + 50L) {
            this.lastUpdate = now;
            this.lastUpdateCount = 0;
            this.lightSourcesLock.readLock().lock();
            for (DynamicLightSource lightSource : this.dynamicLightSources) {
                if (!lightSource.tdv$lambdynlights$updateDynamicLight(renderer)) continue;
                ++this.lastUpdateCount;
            }
            this.lightSourcesLock.readLock().unlock();
        }
    }

    public static boolean shouldUpdateDynLights() {
        boolean shouldNot;
        long currentTime = System.currentTimeMillis();
        EmbyConfig.DynLightsSpeed speed = (EmbyConfig.DynLightsSpeed)((Object)EmbyConfig.dynLightSpeed.get());
        switch (speed) {
            case OFF: {
                boolean bl = true;
                break;
            }
            case SLOW: 
            case NORMAL: 
            case FAST: 
            case SUPERFAST: 
            case FASTESTS: {
                boolean bl;
                if (currentTime < lastUpdateTime + (long)speed.getDelay()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = shouldNot = false;
            }
        }
        if (shouldNot) {
            return false;
        }
        lastUpdateTime = currentTime;
        return true;
    }

    public int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    public int getLightmapWithDynamicLight(@NotNull BlockPos pos, int lightmap) {
        return this.getLightmapWithDynamicLight(this.getDynamicLightLevel(pos), lightmap);
    }

    public int getLightmapWithDynamicLight(@NotNull Entity entity, int lightmap) {
        int posLightLevel = (int)this.getDynamicLightLevel(entity.m_20183_());
        int entityLuminance = ((DynamicLightSource)entity).tdv$getLuminance();
        return this.getLightmapWithDynamicLight(Math.max(posLightLevel, entityLuminance), lightmap);
    }

    public int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = LightTexture.m_109883_((int)lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public double getDynamicLightLevel(@NotNull BlockPos pos) {
        double result = 0.0;
        this.lightSourcesLock.readLock().lock();
        for (DynamicLightSource lightSource : this.dynamicLightSources) {
            result = DynLightsPlus.maxDynamicLightLevel(pos, lightSource, result);
        }
        this.lightSourcesLock.readLock().unlock();
        return Mth.m_14008_((double)result, (double)0.0, (double)15.0);
    }

    public static double maxDynamicLightLevel(@NotNull BlockPos pos, @NotNull DynamicLightSource lightSource, double currentLightLevel) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distanceSquared;
        int luminance = lightSource.tdv$getLuminance();
        if (luminance > 0 && (distanceSquared = (dx = (double)pos.m_123341_() - lightSource.tdv$getDynamicLightX() + 0.5) * dx + (dy = (double)pos.m_123342_() - lightSource.tdv$getDynamicLightY() + 0.5) * dy + (dz = (double)pos.m_123343_() - lightSource.tdv$getDynamicLightZ() + 0.5) * dz) <= 144.0 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 12.0) * (double)luminance) > currentLightLevel) {
            return lightLevel;
        }
        return currentLightLevel;
    }

    public void addLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.tdv$getDynamicLightWorld().m_5776_()) {
            return;
        }
        if (!DynLightsPlus.isEnabled()) {
            return;
        }
        if (this.containsLightSource(lightSource)) {
            return;
        }
        this.lightSourcesLock.writeLock().lock();
        this.dynamicLightSources.add(lightSource);
        this.lightSourcesLock.writeLock().unlock();
    }

    public boolean containsLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.tdv$getDynamicLightWorld().m_5776_()) {
            return false;
        }
        this.lightSourcesLock.readLock().lock();
        boolean result = this.dynamicLightSources.contains(lightSource);
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public int getLightSourcesCount() {
        this.lightSourcesLock.readLock().lock();
        int result = this.dynamicLightSources.size();
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public void removeLightSource(@NotNull DynamicLightSource lightSource) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!it.equals(lightSource)) continue;
            dynamicLightSources.remove();
            lightSource.tdv$lambdynlights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void clearLightSources() {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            dynamicLightSources.remove();
            if (it.tdv$getLuminance() > 0) {
                it.tdv$resetDynamicLight();
            }
            it.tdv$lambdynlights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeLightSources(@NotNull Predicate<DynamicLightSource> filter) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!filter.test(it)) continue;
            dynamicLightSources.remove();
            if (it.tdv$getLuminance() > 0) {
                it.tdv$resetDynamicLight();
            }
            it.tdv$lambdynlights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof Entity && !(lightSource instanceof Player));
    }

    public void removeCreeperLightSources() {
        this.removeLightSources(entity -> entity instanceof Creeper);
    }

    public void removeTntLightSources() {
        this.removeLightSources(entity -> entity instanceof PrimedTnt);
    }

    public void removeBlockEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof BlockEntity);
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, @NotNull BlockPos chunkPos) {
        DynLightsPlus.scheduleChunkRebuild(renderer, chunkPos.m_123341_(), chunkPos.m_123342_(), chunkPos.m_123343_());
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, long chunkPos) {
        DynLightsPlus.scheduleChunkRebuild(renderer, BlockPos.m_121983_((long)chunkPos), BlockPos.m_122008_((long)chunkPos), BlockPos.m_122015_((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, int x, int y, int z) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            renderer.m_109501_(x, y, z, false);
        }
    }

    public static void updateTrackedChunks(@NotNull BlockPos chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.m_121878_();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static void updateTracking(@NotNull DynamicLightSource lightSource) {
        boolean enabled = lightSource.tdv$isDynamicLightEnabled();
        int luminance = lightSource.tdv$getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.tdv$setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.tdv$setDynamicLightEnabled(false);
        }
    }

    public static int getLuminanceFromItemStack(@NotNull ItemStack stack, boolean submergedInWater) {
        return ItemLightRegistry.getLuminance(stack, submergedInWater);
    }

    public static DynLightsPlus get() {
        return INSTANCE;
    }
}

