/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.embeddiumplus.foundation.dynlights.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import me.srrapero720.embeddiumplus.EmbeddiumPlus;
import me.srrapero720.embeddiumplus.foundation.dynlights.item.ItemLightSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

public final class ItemLightRegistry {
    private static final Marker IT = MarkerManager.getMarker((String)"ItemLightRegistry");
    private static final List<ItemLightSource> ITEM_LIGHT_SOURCES = new ArrayList<ItemLightSource>();
    private static final List<ItemLightSource> STATIC_ITEM_LIGHT_SOURCES = new ArrayList<ItemLightSource>();

    public static void load(@NotNull ResourceManager resourceManager) {
        EmbeddiumPlus.LOGGER.info(IT, "{}oading resources", (Object)(ITEM_LIGHT_SOURCES.isEmpty() ? "L" : "Rel"));
        ITEM_LIGHT_SOURCES.clear();
        resourceManager.m_214159_("dynamiclights/item", path -> path.m_135815_().endsWith(".json")).forEach((id, resource) -> ItemLightRegistry.load(resourceManager, id, resource));
        ITEM_LIGHT_SOURCES.addAll(STATIC_ITEM_LIGHT_SOURCES);
    }

    private static void load(@NotNull ResourceManager resourceManager, @NotNull ResourceLocation resourceId, Resource resource) {
        ResourceLocation id = new ResourceLocation(resourceId.m_135827_(), resourceId.m_135815_().replace(".json", ""));
        try {
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(resource.m_215507_())).getAsJsonObject();
            ItemLightSource.fromJson(id, json).ifPresent(data -> {
                if (!STATIC_ITEM_LIGHT_SOURCES.contains(data)) {
                    ItemLightRegistry.register(data);
                }
            });
        }
        catch (IOException | IllegalStateException e) {
            EmbeddiumPlus.LOGGER.warn(IT, "Failed to load item light source '{}'", (Object)id);
        }
    }

    private static void register(@NotNull ItemLightSource data) {
        for (ItemLightSource other : ITEM_LIGHT_SOURCES) {
            if (other.item() != data.item()) continue;
            EmbeddiumPlus.LOGGER.warn(IT, "Failed to register item light source '{}', duplicates item '{}' found in '{}'", (Object)data.id(), (Object)ForgeRegistries.ITEMS.getKey((Object)data.item()), (Object)other.id());
            return;
        }
        ITEM_LIGHT_SOURCES.add(data);
    }

    public static void registerItemLightSource(@NotNull ItemLightSource data) {
        for (ItemLightSource other : STATIC_ITEM_LIGHT_SOURCES) {
            if (other.item() != data.item()) continue;
            EmbeddiumPlus.LOGGER.warn(IT, "Failed to register item light source '{}', duplicates item '{}' found in '{}'", (Object)data.id(), (Object)ForgeRegistries.ITEMS.getKey((Object)data.item()), (Object)other.id());
            return;
        }
        STATIC_ITEM_LIGHT_SOURCES.add(data);
    }

    public static int getLuminance(@NotNull ItemStack stack, boolean submergedInWater) {
        for (ItemLightSource data : ITEM_LIGHT_SOURCES) {
            if (data.item() != stack.m_41720_()) continue;
            return data.getLuminance(stack, submergedInWater);
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return ItemLightSource.BlockItemLightSource.getLuminance(stack, blockItem.m_40614_().m_49966_());
        }
        return 0;
    }
}

