/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.compat.exnihilo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.permutated.exmachinis.ConfigHolder;
import novamachina.exnihilosequentia.common.crafting.sieve.MeshWithChance;
import novamachina.exnihilosequentia.common.crafting.sieve.SieveRecipe;
import novamachina.exnihilosequentia.common.item.HammerBaseItem;
import novamachina.exnihilosequentia.common.item.MeshItem;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.registries.HammerRegistry;

public class ExNihiloAPI {
    private ExNihiloAPI() {
    }

    private static Optional<Block> blockFromItemStack(ItemStack stack) {
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return Optional.of(blockItem.m_40614_());
        }
        return Optional.empty();
    }

    public static boolean canHammer(ItemStack stack) {
        return ExNihiloAPI.blockFromItemStack(stack).map(arg_0 -> ((HammerRegistry)ExNihiloRegistries.HAMMER_REGISTRY).isHammerable(arg_0)).orElse(false);
    }

    public static List<ItemStack> getHammerResult(ItemStack stack) {
        return ExNihiloAPI.blockFromItemStack(stack).map(arg_0 -> ((HammerRegistry)ExNihiloRegistries.HAMMER_REGISTRY).getResult(arg_0)).orElseGet(Collections::emptyList).stream().filter(chance -> (double)chance.getChance() == 1.0 || ThreadLocalRandom.current().nextFloat() <= chance.getChance()).map(chance -> chance.getStack().m_41777_()).toList();
    }

    public static boolean isMeshItem(ItemStack stack) {
        return stack.m_41720_() instanceof MeshItem;
    }

    public static boolean isHammerItem(ItemStack stack) {
        return stack.m_41720_() instanceof HammerBaseItem;
    }

    public static boolean canSieve(ItemStack stack, ItemStack mesh, boolean waterlogged) {
        Item item = mesh.m_41720_();
        if (item instanceof MeshItem) {
            MeshItem meshItem = (MeshItem)item;
            return ExNihiloAPI.blockFromItemStack(stack).map(block -> ExNihiloRegistries.SIEVE_REGISTRY.isBlockSiftable(block, meshItem.getType(), waterlogged)).orElse(false);
        }
        return false;
    }

    public static List<ItemStack> getSieveResult(ItemStack stack, ItemStack mesh, boolean waterlogged) {
        Item item = mesh.m_41720_();
        if (item instanceof MeshItem) {
            MeshItem meshItem = (MeshItem)item;
            List recipes = ExNihiloRegistries.SIEVE_REGISTRY.getDrops((ItemLike)stack.m_41720_(), meshItem.getType(), waterlogged);
            int fortune = 0;
            if (Boolean.TRUE.equals(ConfigHolder.SERVER.sieveFortuneEnabled.get())) {
                fortune = mesh.getEnchantmentLevel(Enchantments.f_44987_);
            }
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            for (SieveRecipe sieveRecipe : recipes) {
                for (MeshWithChance roll : sieveRecipe.getRolls()) {
                    if (!(ThreadLocalRandom.current().nextFloat() <= roll.getChance() * (1.0f + (float)fortune / 3.0f))) continue;
                    output.add(sieveRecipe.getDrop());
                }
            }
            return output;
        }
        return Collections.emptyList();
    }
}

