/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.compat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.compat.jei.category.CompactingCategory;
import net.permutated.exmachinis.util.ResourceUtil;
import net.permutated.exmachinis.util.TranslationKey;
import novamachina.exnihilosequentia.common.compat.jei.RecipeTypes;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceUtil.prefix("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CompactingCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModRegistry.FLUX_COMPACTOR_BLOCK.get()), new RecipeType[]{CompactingCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModRegistry.FLUX_HAMMER_BLOCK.get()), new RecipeType[]{RecipeTypes.HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModRegistry.FLUX_SIEVE_BLOCK.get()), new RecipeType[]{RecipeTypes.DRY_SIEVE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModRegistry.FLUX_SIEVE_BLOCK.get()), new RecipeType[]{RecipeTypes.WET_SIEVE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(CompactingCategory.RECIPE_TYPE, ModRegistry.COMPACTING_REGISTRY.getRecipeList());
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModRegistry.FLUX_COMPACTOR_BLOCK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TranslationKey.translateJei("flux_compactor")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModRegistry.FLUX_HAMMER_BLOCK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TranslationKey.translateJei("flux_hammer")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModRegistry.FLUX_SIEVE_BLOCK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TranslationKey.translateJei("flux_sieve")});
    }
}

