/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.events;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.permutated.exmachinis.ExMachinis;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.compat.exnihilo.ExNihiloAPI;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;
import net.permutated.exmachinis.util.Constants;

@Mod.EventBusSubscriber(modid="exmachinis", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEventHandler {
    public static final int BLUE = FastColor.ARGB32.m_13660_((int)255, (int)30, (int)136, (int)229);

    private ClientEventHandler() {
    }

    @SubscribeEvent
    public static void onClientLoggedOutEvent(ClientPlayerNetworkEvent.LoggingOut event) {
        ExMachinis.LOGGER.debug("Clearing recipe cache after logging out");
        ModRegistry.COMPACTING_REGISTRY.clearRecipes();
    }

    @SubscribeEvent
    public static void onRenderHighlightEvent(RenderHighlightEvent.Block event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack inHand = player.m_21205_();
        if (inHand.m_41619_() || !ExNihiloAPI.isHammerItem(inHand)) {
            return;
        }
        BlockPos pos = event.getTarget().m_82425_();
        BlockState state = player.m_20193_().m_8055_(pos);
        if (!state.m_60795_() && state.m_60734_() instanceof AbstractMachineBlock) {
            Direction output = (Direction)state.m_61143_((Property)AbstractMachineBlock.OUTPUT);
            Vec3 offset = Vec3.m_82528_((Vec3i)pos).m_82546_(event.getCamera().m_90583_());
            PoseStack poseStack = event.getPoseStack();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer consumer = bufferSource.m_6299_(OutputRenderType.OVERLAY_LINES);
            poseStack.m_85836_();
            poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_85845_(Constants.ROTATIONS.get(output));
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            ClientEventHandler.drawLine(consumer, poseStack, 0.0f, 0.25f, 0.25f, 0.0f, 0.25f, 0.75f);
            ClientEventHandler.drawLine(consumer, poseStack, 0.0f, 0.75f, 0.25f, 0.0f, 0.75f, 0.75f);
            ClientEventHandler.drawLine(consumer, poseStack, 0.0f, 0.25f, 0.25f, 0.0f, 0.75f, 0.25f);
            ClientEventHandler.drawLine(consumer, poseStack, 0.0f, 0.25f, 0.75f, 0.0f, 0.75f, 0.75f);
            poseStack.m_85849_();
            bufferSource.m_109912_(OutputRenderType.OVERLAY_LINES);
        }
    }

    static void drawLine(VertexConsumer consumer, PoseStack stack, float x1, float y1, float z1, float x2, float y2, float z2) {
        float nX = x2 - x1;
        float nY = y2 - y1;
        float nZ = z2 - z1;
        float nLen = Mth.m_14116_((float)(nX * nX + nY * nY + nZ * nZ));
        consumer.m_85982_(stack.m_85850_().m_85861_(), x1, y1, z1).m_193479_(BLUE).m_85977_(stack.m_85850_().m_85864_(), nX /= nLen, nY /= nLen, nZ /= nLen).m_5752_();
        consumer.m_85982_(stack.m_85850_().m_85861_(), x2, y2, z2).m_193479_(BLUE).m_85977_(stack.m_85850_().m_85864_(), nX, nY, nZ).m_5752_();
    }

    static class OutputRenderType
    extends RenderType {
        public static final RenderType OVERLAY_LINES = OutputRenderType.m_173215_((String)"overlay_lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(3.0))).m_110669_(RenderStateShard.f_110119_).m_110685_(f_110139_).m_110675_(RenderStateShard.f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));

        public OutputRenderType(String p_173178_, VertexFormat p_173179_, VertexFormat.Mode p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
            super(p_173178_, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
        }
    }
}

