/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.formattingrules;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.formattingrules.HighlightPlaceholdersFormattingRule;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.formattingrules.brackets.HighlightAngleBracketsFormattingRule;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.formattingrules.brackets.HighlightCurlyBracketsFormattingRule;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.formattingrules.brackets.HighlightRoundBracketsFormattingRule;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.formattingrules.brackets.HighlightSquareBracketsFormattingRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextEditorFormattingRules {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<Class<? extends TextEditorFormattingRule>> RULE_CLASSES = new ArrayList<Class<? extends TextEditorFormattingRule>>();

    public static void addRuleAtTop(Class<? extends TextEditorFormattingRule> rule) {
        if (!RULE_CLASSES.contains(rule)) {
            RULE_CLASSES.add(0, rule);
        }
    }

    public static void addRuleAtBottom(Class<? extends TextEditorFormattingRule> rule) {
        if (!RULE_CLASSES.contains(rule)) {
            RULE_CLASSES.add(rule);
        }
    }

    public static List<TextEditorFormattingRule> getRules() {
        ArrayList<TextEditorFormattingRule> r = new ArrayList<TextEditorFormattingRule>();
        for (Class<? extends TextEditorFormattingRule> rule : RULE_CLASSES) {
            try {
                r.add(rule.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                LOGGER.error("[FANCYMENU] Unable to construct new instance of rule (" + (rule != null ? rule.getName() : "NULL") + ")!");
                LOGGER.error("[FANCYMENU] Rules need an empty public constructor!");
                e.printStackTrace();
            }
        }
        return r;
    }

    static {
        TextEditorFormattingRules.addRuleAtTop(HighlightPlaceholdersFormattingRule.class);
        TextEditorFormattingRules.addRuleAtBottom(HighlightAngleBracketsFormattingRule.class);
        TextEditorFormattingRules.addRuleAtBottom(HighlightCurlyBracketsFormattingRule.class);
        TextEditorFormattingRules.addRuleAtBottom(HighlightRoundBracketsFormattingRule.class);
        TextEditorFormattingRules.addRuleAtBottom(HighlightSquareBracketsFormattingRule.class);
    }
}

