/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.client;

import de.keksuccino.fancymenu.mainwindow.WindowHandler;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.thread.MainThreadTaskExecutor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.main.GameConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MixinMinecraft {
    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void setCustomWindowIconFancyMenu(GameConfig p_91084_, CallbackInfo info) {
        WindowHandler.updateWindowIcon();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onClientTickPre(CallbackInfo info) {
        for (Runnable r : MainThreadTaskExecutor.getAndClearQueue(MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK)) {
            try {
                r.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void onClientTickPost(CallbackInfo info) {
        for (Runnable r : MainThreadTaskExecutor.getAndClearQueue(MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK)) {
            try {
                r.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"createTitle"}, cancellable=true)
    private void setCustomWindowTitleFancyMenu(CallbackInfoReturnable<String> info) {
        WindowHandler.readCustomWindowTitleFromConfig();
        String title = WindowHandler.getCustomWindowTitle();
        if (title != null) {
            info.setReturnValue((Object)title);
        }
    }

    @Inject(method={"setOverlay"}, at={@At(value="HEAD")})
    private void onSetOverlayFancyMenu(Overlay overlay, CallbackInfo info) {
        if (overlay == null) {
            AnimationHandler.setReady(true);
            MenuCustomization.allowScreenCustomization = true;
        } else {
            AnimationHandler.setReady(false);
            MenuCustomization.allowScreenCustomization = false;
        }
    }
}

