/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.datagen.recipes;

import com.google.gson.JsonObject;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public class MachineFuelRecipeBuilder {
    private RecipeSerializer<?> serializer;
    private Ingredient ingredient;
    private int ticks;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public static MachineFuelRecipeBuilder basicGenerator(Ingredient ingredient, int ticks) {
        MachineFuelRecipeBuilder builder = new MachineFuelRecipeBuilder();
        builder.serializer = FTBICRecipes.BASIC_GENERATOR_FUEL.get();
        builder.ingredient = ingredient;
        builder.ticks = ticks;
        return builder;
    }

    public MachineFuelRecipeBuilder unlockedBy(String string, CriterionTriggerInstance arg) {
        this.advancement.m_138386_(string, arg);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(this, id, new ResourceLocation(id.m_135827_(), "recipes/ftbic_fuel/" + id.m_135815_())));
    }

    public static class Result
    implements FinishedRecipe {
        private final MachineFuelRecipeBuilder builder;
        private final ResourceLocation id;
        private final ResourceLocation advancementId;

        private Result(MachineFuelRecipeBuilder b, ResourceLocation i, ResourceLocation a) {
            this.builder = b;
            this.id = i;
            this.advancementId = a;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.builder.ingredient.m_43942_());
            json.addProperty("ticks", (Number)this.builder.ticks);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.builder.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.builder.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

