/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import dev.ftb.mods.ftbteams.net.UpdateSettingsResponseMessage;
import dev.ftb.mods.ftbteams.property.TeamProperties;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class UpdateSettingsMessage
extends BaseC2SMessage {
    public final TeamProperties properties;

    UpdateSettingsMessage(FriendlyByteBuf buffer) {
        this.properties = new TeamProperties();
        this.properties.read(buffer);
    }

    public UpdateSettingsMessage(TeamProperties p) {
        this.properties = p;
    }

    public MessageType getType() {
        return FTBTeamsNet.UPDATE_SETTINGS;
    }

    public void write(FriendlyByteBuf buffer) {
        this.properties.write(buffer);
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        Team team = FTBTeamsAPI.getPlayerTeam(player);
        if (!team.isOfficer(player.m_20148_())) {
            return;
        }
        TeamProperties old = team.properties.copy();
        team.properties.updateFrom(this.properties);
        ((Consumer)TeamEvent.PROPERTIES_CHANGED.invoker()).accept(new TeamPropertiesChangedEvent(team, old));
        team.save();
        new UpdateSettingsResponseMessage(team.getId(), team.properties).sendToAll(player.f_8924_);
    }
}

