/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.net.covers1624.quack.collection.redblack;

import java.util.Iterator;
import java.util.Objects;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public abstract class RedBlackNode<T extends RedBlackNode<T>> {
    @Nullable
    private T left;
    @Nullable
    private T right;
    private boolean isRed;
    @Nullable
    private T parent;

    void makeRoot() {
        this.setParent(null);
    }

    public T getRoot() {
        if (this.parent == null) {
            return (T)((RedBlackNode)SneakyUtils.unsafeCast(this));
        }
        return ((RedBlackNode)this.parent).getRoot();
    }

    public boolean getSide() {
        return ((RedBlackNode)this.requireParent()).getRight() == this;
    }

    @Nullable
    public T getSibling() {
        return ((RedBlackNode)this.requireParent()).getChild(!this.getSide());
    }

    @Nullable
    public T getChild(boolean r) {
        return r ? this.right : this.left;
    }

    public void assign(boolean r, @Nullable T n) {
        if (r) {
            this.setRight(n);
        } else {
            this.setLeft(n);
        }
    }

    public T getLeftMost() {
        if (this.left == null) {
            return (T)((RedBlackNode)SneakyUtils.unsafeCast(this));
        }
        return ((RedBlackNode)this.left).getLeftMost();
    }

    public T getRightMost() {
        if (this.right == null) {
            return (T)((RedBlackNode)SneakyUtils.unsafeCast(this));
        }
        return ((RedBlackNode)this.right).getRightMost();
    }

    public T most(boolean r) {
        return r ? this.getRightMost() : this.getLeftMost();
    }

    public T getNext() {
        return this.closest(true);
    }

    public T getPrev() {
        return this.closest(false);
    }

    public T closest(boolean r) {
        T next = this.getChild(r);
        if (next != null) {
            next = ((RedBlackNode)next).most(!r);
        }
        if (next != null) {
            return next;
        }
        RedBlackNode<T> curr = (RedBlackNode)SneakyUtils.unsafeCast(this);
        while (curr.getParent() != null && curr.getSide() == r) {
            curr = curr.getParent();
        }
        return curr.getParent();
    }

    public Iterable<T> to(T last) {
        return () -> new Iterator<T>((RedBlackNode)last){
            @Nullable
            private RedBlackNode p;
            final /* synthetic */ RedBlackNode val$last;
            {
                this.val$last = redBlackNode;
                this.p = (RedBlackNode)SneakyUtils.unsafeCast(RedBlackNode.this);
            }

            @Override
            public boolean hasNext() {
                return this.p != null;
            }

            @Override
            public T next() {
                assert (this.p != null);
                RedBlackNode curr = this.p;
                this.p = curr == this.val$last ? null : curr.getNext();
                return curr;
            }
        };
    }

    public void onChildrenChanged() {
    }

    @Nullable
    public T getLeft() {
        return this.left;
    }

    void setLeft(@Nullable T left) {
        this.left = left;
        if (left != null) {
            left.setParent((RedBlackNode)((RedBlackNode)SneakyUtils.unsafeCast(this)));
        }
    }

    @Nullable
    public T getRight() {
        return this.right;
    }

    public void setRight(@Nullable T right) {
        this.right = right;
        if (right != null) {
            right.setParent((RedBlackNode)((RedBlackNode)SneakyUtils.unsafeCast(this)));
        }
    }

    public boolean isRed() {
        return this.isRed;
    }

    @Nullable
    public T getParent() {
        return this.parent;
    }

    public T requireParent() {
        return (T)((RedBlackNode)Objects.requireNonNull(this.parent));
    }

    public boolean isBlack() {
        return !this.isRed;
    }

    void setRed(boolean red) {
        this.isRed = red;
    }

    void setParent(@Nullable T parent) {
        this.parent = parent;
    }

    void setBlack(boolean black) {
        this.isRed = !black;
    }
}

