/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.net.covers1624.quack.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Predicate;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.util.SneakyUtils;

public class CopyingFileVisitor
extends SimpleFileVisitor<Path> {
    private final Path fromRoot;
    private final Path toRoot;
    private final Predicate<Path> predicate;

    public CopyingFileVisitor(Path fromRoot, Path toRoot) {
        this(fromRoot, toRoot, SneakyUtils.trueP());
    }

    public CopyingFileVisitor(Path fromRoot, Path toRoot, Predicate<Path> predicate) {
        this.fromRoot = fromRoot;
        this.toRoot = toRoot;
        this.predicate = predicate;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path rel = this.fromRoot.relativize(dir);
        if (!this.predicate.test(rel)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return super.preVisitDirectory(dir, attrs);
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path rel = this.fromRoot.relativize(file);
        if (!this.predicate.test(rel)) {
            return FileVisitResult.CONTINUE;
        }
        Path to = this.toRoot.resolve(rel.toString());
        Files.createDirectories(to.getParent(), new FileAttribute[0]);
        Files.copy(file, to, StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }
}

