/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.inventory;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.inventory.BigInventoryHandler;
import com.buuz135.functionalstorage.inventory.ILockable;
import com.buuz135.functionalstorage.world.EnderSavedData;
import net.minecraft.nbt.CompoundTag;

public class EnderInventoryHandler
extends BigInventoryHandler
implements ILockable {
    public static String NBT_LOCKED = "Locked";
    public static String NBT_VOID = "Void";
    private final EnderSavedData manager;
    private String frequency;
    private boolean locked;
    private boolean voidItems;

    public EnderInventoryHandler(String frequency, EnderSavedData manager) {
        super(FunctionalStorage.DrawerType.X_1);
        this.manager = manager;
        this.frequency = frequency;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = super.serializeNBT();
        compoundTag.m_128379_(NBT_LOCKED, this.locked);
        compoundTag.m_128379_(NBT_VOID, this.voidItems);
        return compoundTag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.locked = nbt.m_128471_(NBT_LOCKED);
        this.voidItems = nbt.m_128471_(NBT_VOID);
    }

    @Override
    public void onChange() {
        this.manager.m_77762_();
    }

    @Override
    public int getSlotLimit(int slot) {
        if (slot == 1) {
            return Integer.MAX_VALUE;
        }
        double stackSize = 1.0;
        if (!this.getStoredStacks().get(slot).getStack().m_41619_()) {
            stackSize = (double)this.getStoredStacks().get(slot).getStack().m_41741_() / 64.0;
        }
        return (int)Math.floor((double)Math.min(Integer.MAX_VALUE, FunctionalStorage.DrawerType.X_1.getSlotAmount() * 4) * stackSize);
    }

    @Override
    public int getMultiplier() {
        return 1;
    }

    @Override
    public boolean isVoid() {
        return this.voidItems;
    }

    @Override
    public boolean hasDowngrade() {
        return false;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean isCreative() {
        return false;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.manager.m_77762_();
    }

    public void setVoidItems(boolean voidItems) {
        this.voidItems = voidItems;
        this.manager.m_77762_();
    }
}

