/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.container.HerbJarContainer;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.items.JarHandler;
import net.joefoxe.hexerei.tileentity.HerbJarTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;

public class HerbJar
extends Block
implements ITileEntity<HerbJarTile>,
EntityBlock,
SimpleWaterloggedBlock,
DyeableLeatherItem {
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty GUI_RENDER = BooleanProperty.m_61465_((String)"gui_render");
    public static final BooleanProperty DYED = BooleanProperty.m_61465_((String)"dyed");
    public static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)5.0, (double)-0.5, (double)5.0, (double)11.0, (double)0.0, (double)11.0), Block.m_49796_((double)5.5, (double)13.0, (double)5.5, (double)10.5, (double)15.0, (double)10.5), Block.m_49796_((double)4.5, (double)12.0, (double)10.5, (double)11.5, (double)14.0, (double)11.5), Block.m_49796_((double)4.5, (double)12.0, (double)4.5, (double)11.5, (double)14.0, (double)5.5), Block.m_49796_((double)4.5, (double)12.0, (double)5.5, (double)5.5, (double)14.0, (double)10.5), Block.m_49796_((double)10.5, (double)12.0, (double)5.5, (double)11.5, (double)14.0, (double)10.5), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.m_49796_((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public RenderShape m_7514_(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockstate = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)((BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_))).m_61124_((Property)GUI_RENDER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DYED, (Comparable)Boolean.valueOf(HexereiUtil.getColorStatic(context.m_43722_()) != 4337438))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_());
        }
        return null;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (player.m_21120_(handIn).m_150930_((Item)ModItems.CROW_FLUTE.get()) && player.m_21120_(handIn).m_41784_().m_128451_("commandMode") == 2) {
            player.m_21120_(handIn).m_41661_(new UseOnContext(player, handIn, hit));
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41619_() && player.m_6144_() || ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_() != hit.m_82434_()) {
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            if (!worldIn.m_5776_()) {
                if (tileEntity instanceof HerbJarTile) {
                    ((HerbJarTile)tileEntity).sync();
                    MenuProvider containerProvider = this.createContainerProvider(worldIn, pos, this.m_7397_((BlockGetter)worldIn, pos, state));
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, b -> b.m_130064_(tileEntity.m_58899_()).m_130055_(this.m_7397_((BlockGetter)worldIn, pos, state)));
                } else {
                    throw new IllegalStateException("Our Container provider is missing!");
                }
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof HerbJarTile) {
            ((HerbJarTile)tileEntity).interactPutItems(player);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = level.m_7702_(pos);
            if (tileentity != null) {
                ItemStack cloneItemStack = this.m_7397_((BlockGetter)level, pos, state);
                if (!level.m_5776_()) {
                    HerbJar.m_49840_((Level)level, (BlockPos)pos, (ItemStack)cloneItemStack);
                }
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    protected BlockHitResult rayTraceEyeLevel(Level world, Player player, double length) {
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookPos = player.m_20252_(1.0f);
        Vec3 endPos = eyePos.m_82520_(lookPos.f_82479_ * length, lookPos.f_82480_ * length, lookPos.f_82481_ * length);
        ClipContext context = new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        return world.m_45547_(context);
    }

    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player playerIn) {
        BlockHitResult rayResult = this.rayTraceEyeLevel(worldIn, playerIn, playerIn.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() + 1.0);
        if (rayResult.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        Direction side = rayResult.m_82434_();
        BlockEntity tile = worldIn.m_7702_(pos);
        HerbJarTile herbJarTile = null;
        if (tile instanceof HerbJarTile) {
            herbJarTile = (HerbJarTile)tile;
        }
        if (((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_() != rayResult.m_82434_()) {
            return;
        }
        ItemStack item = playerIn.m_6144_() ? herbJarTile.takeItems(0, herbJarTile.itemHandler.getStackInSlot(0).m_41613_()) : herbJarTile.takeItems(0, 1);
        if (!item.m_41619_()) {
            if (!playerIn.f_36093_.m_36054_(item)) {
                this.dropItemStack(worldIn, pos.m_121945_(side), playerIn, item);
                worldIn.m_7260_(pos, state, state, 3);
            } else {
                worldIn.m_6263_(null, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((worldIn.f_46441_.m_188501_() - worldIn.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        super.m_6256_(state, worldIn, pos, playerIn);
    }

    private void dropItemStack(Level world, BlockPos pos, Player player, @Nonnull ItemStack stack) {
        ItemEntity entity = new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.3f), (double)((float)pos.m_123343_() + 0.5f), stack);
        Vec3 motion = entity.m_20184_();
        entity.m_5997_(-motion.f_82479_, -motion.f_82480_, -motion.f_82481_);
        world.m_7967_((Entity)entity);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public HerbJar(BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)GUI_RENDER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DYED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_, HANGING, WATERLOGGED, GUI_RENDER, DYED});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, world, tooltip, flagIn);
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        Component customName;
        int toggled;
        int col;
        ItemStack item = new ItemStack((ItemLike)this);
        Optional<HerbJarTile> tileEntityOptional = Optional.ofNullable((HerbJarTile)this.getBlockEntity(worldIn, pos));
        CompoundTag tag = item.m_41784_();
        JarHandler empty = tileEntityOptional.map(herb_jar -> herb_jar.itemHandler).orElse(new JarHandler(1, 1024));
        CompoundTag inv = tileEntityOptional.map(herb_jar -> herb_jar.itemHandler.serializeNBT()).orElse(new CompoundTag());
        if (!empty.getStackInSlot(0).m_41619_()) {
            tag.m_128365_("Inventory", (Tag)inv);
        }
        if ((col = tileEntityOptional.map(herbJarTile -> herbJarTile.dyeColor).orElse(4337438).intValue()) != 4337438 && col != 0) {
            this.m_41115_(item, col);
        }
        if ((toggled = tileEntityOptional.map(herbJarTile -> herbJarTile.buttonToggled).orElse(0).intValue()) == 1) {
            tag.m_128405_("ButtonToggled", toggled);
        }
        if ((customName = (Component)tileEntityOptional.map(HerbJarTile::m_7770_).orElse(null)) != null && customName.getString().length() > 0) {
            item.m_41714_(customName);
        }
        return item;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (stack.m_41788_()) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            ((HerbJarTile)tileentity).customName = stack.m_41786_();
        }
        if (worldIn.m_5776_()) {
            return;
        }
        if (stack == null) {
            return;
        }
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> {
            te.readInventory(stack.m_41784_().m_128469_("Inventory"));
            DyeColor col = HexereiUtil.getDyeColorNamed(stack.m_41786_().getString());
            int intCol = -1;
            if (col != null) {
                intCol = HexereiUtil.getColorValue(col);
            }
            if (intCol == -1) {
                intCol = HexereiUtil.getColorStatic(stack);
            }
            te.setDyeColor(intCol);
            te.buttonToggled = stack.m_41784_().m_128451_("ButtonToggled");
        });
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidStateIn.m_76152_() == Fluids.f_76193_) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 3);
            worldIn.m_186469_(pos, fluidStateIn.m_76152_(), fluidStateIn.m_76152_().m_6718_((LevelReader)worldIn));
            return true;
        }
        return false;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = HerbJar.getBlockConnected(state).m_122424_();
        return Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_121945_(direction), (Direction)direction.m_122424_());
    }

    protected static Direction getBlockConnected(BlockState state) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
    }

    private MenuProvider createContainerProvider(final Level worldIn, final BlockPos pos, final ItemStack stack) {
        return new MenuProvider(){

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return new HerbJarContainer(i, stack, worldIn, pos, playerInventory, playerEntity);
            }

            public Component m_5446_() {
                if (((HerbJarTile)worldIn.m_7702_((BlockPos)pos)).customName != null) {
                    return Component.m_237115_((String)((HerbJarTile)worldIn.m_7702_((BlockPos)pos)).customName.getString());
                }
                return Component.m_237115_((String)"screen.hexerei.herb_jar");
            }
        };
    }

    @Override
    public Class<HerbJarTile> getTileEntityClass() {
        return HerbJarTile.class;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HerbJarTile((BlockEntityType)ModTileEntities.HERB_JAR_TILE.get(), pos, state);
    }
}

