/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PestleAndMortarRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final int grindingTime;
    private final NonNullList<Ingredient> recipeItems;
    protected static final List<Boolean> itemMatchesSlot = new ArrayList<Boolean>();

    public boolean m_5598_() {
        return true;
    }

    public PestleAndMortarRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, int grindingTime) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
        this.grindingTime = grindingTime;
        for (int i = 0; i < 5; ++i) {
            itemMatchesSlot.add(false);
        }
    }

    public boolean matches(SimpleContainer inv, Level worldIn) {
        for (int i = 0; i < 5; ++i) {
            itemMatchesSlot.set(i, false);
        }
        boolean flag = false;
        int numberOfEmpty = 5 - this.recipeItems.size();
        for (Ingredient recipeItem : this.recipeItems) {
            for (int i = 0; i < 5; ++i) {
                if (!recipeItem.test(inv.m_8020_(i)) || itemMatchesSlot.get(i).booleanValue()) continue;
                itemMatchesSlot.set(i, true);
                flag = true;
                break;
            }
            if (!flag) break;
            flag = false;
        }
        for (int j = 0; j < numberOfEmpty; ++j) {
            for (int i = 0; i < 5; ++i) {
                if (!inv.m_8020_(i).m_41619_() || itemMatchesSlot.get(i).booleanValue()) continue;
                itemMatchesSlot.set(i, true);
                flag = true;
                break;
            }
            if (!flag) break;
            flag = false;
        }
        for (int i = 0; i < 5; ++i) {
            if (itemMatchesSlot.get(i).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public ItemStack assemble(SimpleContainer inv) {
        return this.output;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.PESTLE_AND_MORTAR.get());
    }

    public int getGrindingTime() {
        return this.grindingTime;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.PESTLE_AND_MORTAR_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Type
    implements RecipeType<PestleAndMortarRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "pestle_and_mortar";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<PestleAndMortarRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("hexerei", "pestle_and_mortar");

        public PestleAndMortarRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)ingredients.size(), (Object)Ingredient.f_43901_);
            int grindingTime = GsonHelper.m_13927_((JsonObject)json, (String)"grindingTime");
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new PestleAndMortarRecipe(recipeId, output, (NonNullList<Ingredient>)inputs, grindingTime);
        }

        @Nullable
        public PestleAndMortarRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            NonNullList inputs = NonNullList.m_122780_((int)buffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            return new PestleAndMortarRecipe(recipeId, buffer.m_130267_(), (NonNullList<Ingredient>)inputs, buffer.readInt());
        }

        public void toNetwork(FriendlyByteBuf buffer, PestleAndMortarRecipe recipe) {
            buffer.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
            buffer.writeInt(recipe.getGrindingTime());
        }
    }
}

