/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.transporter;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.RegulatorFilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.buuz135.industrial.proxy.network.TransporterSyncMessage;
import com.hrznstudio.titanium.network.Message;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class FilteredTransporterType<TYPE, CAP>
extends TransporterType {
    private RegulatorFilter<TYPE, CAP> filter = this.createFilter();
    private boolean whitelist = false;
    private boolean isRegulated = false;

    public FilteredTransporterType(IBlockContainer container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        super(container, factory, side, action);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            if (compound.m_128441_("Amount")) {
                this.filter.getFilter()[buttonId].increaseAmount(compound.m_128451_("Amount"));
            } else {
                this.filter.setFilter(buttonId, ItemStack.m_41712_((CompoundTag)compound));
            }
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
        if (buttonId == 17) {
            this.isRegulated = !this.isRegulated;
            this.getContainer().requestSync();
        }
    }

    public abstract RegulatorFilter<TYPE, CAP> createFilter();

    @Override
    public void handleRenderSync(Direction origin, CompoundTag compoundNBT) {
    }

    @Override
    public void syncRender(Direction origin, CompoundTag compoundNBT) {
        IndustrialForegoing.NETWORK.sendToNearby(this.getLevel(), this.getPos(), 32, (Message)new TransporterSyncMessage(this.getPos(), compoundNBT, this.getSide().m_122411_(), origin.m_122411_()));
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new RegulatorFilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public RegulatorFilter<TYPE, CAP> getFilter() {
                return FilteredTransporterType.this.filter;
            }

            @Override
            public boolean isRegulator() {
                return FilteredTransporterType.this.isRegulated;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return FilteredTransporterType.this.whitelist ? 0 : 1;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(17, 133, 40, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 58, 233, new String[]{"regulated_true"}), new StateButtonInfo(1, res, 77, 233, new String[]{"regulated_false"})}){

            @Override
            public int getState() {
                return FilteredTransporterType.this.isRegulated ? 0 : 1;
            }
        });
    }

    @Override
    public boolean ignoresCollision() {
        return false;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = super.serializeNBT();
        compoundNBT.m_128365_("Filter", (Tag)this.filter.serializeNBT());
        compoundNBT.m_128379_("Whitelist", this.whitelist);
        compoundNBT.m_128379_("Regulated", this.isRegulated);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        if (nbt.m_128441_("Filter")) {
            this.filter.deserializeNBT(nbt.m_128469_("Filter"));
        }
        this.whitelist = nbt.m_128471_("Whitelist");
        this.isRegulated = nbt.m_128471_("Regulated");
    }

    public RegulatorFilter<TYPE, CAP> getFilter() {
        return this.filter;
    }

    public boolean isWhitelist() {
        return this.whitelist;
    }

    public boolean isRegulated() {
        return this.isRegulated;
    }
}

