/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTool;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class MeatFeederItem
extends IFCustomItem {
    public MeatFeederItem(CreativeModeTab group) {
        super("meat_feeder", group, new Item.Properties().m_41487_(1));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        FluidHandlerItemStack handlerItemStack = new FluidHandlerItemStack(stack, 512000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid.getFluid().m_6212_((Fluid)ModuleCore.MEAT.getSourceFluid().get());
            }
        };
        handlerItemStack.fill(new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), 0), IFluidHandler.FluidAction.EXECUTE);
        return handlerItemStack;
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        if (stack.m_41783_() != null && key == null) {
            tooltip.add((Component)Component.m_237113_((String)(NumberFormat.getNumberInstance(Locale.ROOT).format(stack.m_41783_().m_128469_("Fluid").m_128451_("Amount")) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + NumberFormat.getNumberInstance(Locale.ROOT).format(512000L) + ChatFormatting.GOLD + "mb of Meat")));
        }
    }

    public int getFilledAmount(ItemStack stack) {
        FluidHandlerItemStack handlerItemStack = (FluidHandlerItemStack)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElseThrow(RuntimeException::new);
        return handlerItemStack.getFluid() == null ? 0 : handlerItemStack.getFluid().getAmount();
    }

    public void drain(ItemStack stack, int amount) {
        FluidHandlerItemStack handlerItemStack = (FluidHandlerItemStack)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElseThrow(RuntimeException::new);
        handlerItemStack.drain(new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Player player;
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.f_46443_ && entityIn instanceof Player && ((player = (Player)entityIn).m_36324_().m_38721_() || player.m_36324_().m_38722_() < 10.0f) && stack.m_41720_().equals(ModuleTool.MEAT_FEEDER.get())) {
            MeatFeederItem.meatTick(stack, player);
        }
    }

    public static boolean meatTick(ItemStack stack, Player player) {
        int filledAmount = ((MeatFeederItem)stack.m_41720_()).getFilledAmount(stack);
        if (filledAmount >= 400 && (player.m_36324_().m_38722_() < 20.0f || player.m_36324_().m_38702_() < 20)) {
            ((MeatFeederItem)stack.m_41720_()).drain(stack, 400);
            player.m_36324_().m_38707_(1, 1.0f);
            return true;
        }
        return false;
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).m_126130_("pip").m_126130_("gig").m_126130_(" i ").m_126127_(Character.valueOf('p'), (ItemLike)ModuleCore.PLASTIC.get()).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('g'), (ItemLike)Items.f_42590_).m_176498_(consumer);
    }
}

