/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.itemcollectors.CollectorBlock;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.ItemCollectorsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class CollectorBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    private static final int MIN_RANGE = 1;
    private final Supplier<Integer> maxRange;
    private final Supplier<Boolean> hasFilter;
    public int rangeX;
    public int rangeY;
    public int rangeZ;
    public final List<ItemStack> filter = new ArrayList<ItemStack>(9);
    public boolean filterWhitelist;
    public boolean filterDurability = true;
    public boolean showArea = false;

    public static CollectorBlockEntity basicCollectorEntity(BlockPos pos, BlockState state) {
        return new CollectorBlockEntity(ItemCollectors.basic_collector_tile, pos, state, ItemCollectorsConfig.basicCollectorMaxRange, ItemCollectorsConfig.basicCollectorFilter);
    }

    public static CollectorBlockEntity advancedCollectorEntity(BlockPos pos, BlockState state) {
        return new CollectorBlockEntity(ItemCollectors.advanced_collector_tile, pos, state, ItemCollectorsConfig.advancedCollectorMaxRange, ItemCollectorsConfig.advancedCollectorFilter);
    }

    public CollectorBlockEntity(BaseBlockEntityType<CollectorBlockEntity> blockEntityType, BlockPos pos, BlockState state, Supplier<Integer> maxRange, Supplier<Boolean> hasFilter) {
        super(blockEntityType, pos, state);
        this.maxRange = maxRange;
        this.rangeY = this.rangeZ = (int)Math.ceil((float)maxRange.get().intValue() / 2.0f);
        this.rangeX = this.rangeZ;
        this.hasFilter = hasFilter;
        for (int i = 0; i < 9; ++i) {
            this.filter.add(ItemStack.f_41583_);
        }
    }

    public void update() {
        if (!this.f_58857_.f_46443_) {
            this.getOutputItemHandler().ifPresent(itemHandler -> {
                if (itemHandler.getSlots() <= 0) {
                    return;
                }
                AABB area = this.getAffectedArea();
                List items = this.f_58857_.m_6443_(ItemEntity.class, area, item -> {
                    if (!item.m_6084_() || item.getPersistentData().m_128441_("PreventRemoteMovement") && !item.getPersistentData().m_128441_("AllowMachineRemoteMovement")) {
                        return false;
                    }
                    ItemStack stack = item.m_32055_();
                    if (stack.m_41619_()) {
                        return false;
                    }
                    if (!this.hasFilter.get().booleanValue()) {
                        return true;
                    }
                    for (int i = 0; i < 9; ++i) {
                        ItemStack filter = this.filter.get(i);
                        if (!ItemStack.m_41746_((ItemStack)filter, (ItemStack)stack) || this.filterDurability && !ItemStack.m_41658_((ItemStack)filter, (ItemStack)stack)) continue;
                        return this.filterWhitelist;
                    }
                    return !this.filterWhitelist;
                });
                block0: for (ItemEntity entity : items) {
                    ItemStack stack = entity.m_32055_().m_41777_();
                    for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                        if (!itemHandler.isItemValid(slot, stack) || !(stack = itemHandler.insertItem(slot, stack, false)).m_41619_()) continue;
                        entity.m_32045_(ItemStack.f_41583_);
                        entity.m_142687_(Entity.RemovalReason.DISCARDED);
                        continue block0;
                    }
                    entity.m_32045_(stack);
                }
            });
        }
    }

    public AABB getAffectedArea() {
        return new AABB(this.f_58858_.m_7918_(-this.rangeX, -this.rangeY, -this.rangeZ), this.f_58858_.m_7918_(this.rangeX + 1, this.rangeY + 1, this.rangeZ + 1));
    }

    private LazyOptional<IItemHandler> getOutputItemHandler() {
        BlockState state = this.m_58900_();
        if (!state.m_61138_(CollectorBlock.DIRECTION)) {
            return LazyOptional.empty();
        }
        Direction direction = (Direction)state.m_61143_(CollectorBlock.DIRECTION);
        BlockEntity entity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
        if (entity == null) {
            return LazyOptional.empty();
        }
        return entity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_());
    }

    public void setRangeX(int range) {
        int old = this.rangeX;
        this.rangeX = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeX != old) {
            this.dataChanged();
        }
    }

    public void setRangeY(int range) {
        int old = this.rangeY;
        this.rangeY = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeY != old) {
            this.dataChanged();
        }
    }

    public void setRangeZ(int range) {
        int old = this.rangeZ;
        this.rangeZ = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeZ != old) {
            this.dataChanged();
        }
    }

    public void setShowArea(boolean showArea) {
        if (this.showArea != showArea) {
            this.showArea = showArea;
            this.dataChanged();
        }
    }

    protected CompoundTag writeData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("rangeX", this.rangeX);
        tag.m_128405_("rangeY", this.rangeY);
        tag.m_128405_("rangeZ", this.rangeZ);
        for (int i = 0; i < 9; ++i) {
            if (this.filter.get(i).m_41619_()) continue;
            tag.m_128365_("filter" + i, (Tag)this.filter.get(i).m_41739_(new CompoundTag()));
        }
        tag.m_128379_("filterWhitelist", this.filterWhitelist);
        tag.m_128379_("filterDurability", this.filterDurability);
        tag.m_128379_("showArea", this.showArea);
        return tag;
    }

    protected void readData(CompoundTag tag) {
        if (tag.m_128441_("rangeX")) {
            this.rangeX = tag.m_128451_("rangeX");
        }
        if (tag.m_128441_("rangeY")) {
            this.rangeY = tag.m_128451_("rangeY");
        }
        if (tag.m_128441_("rangeZ")) {
            this.rangeZ = tag.m_128451_("rangeZ");
        }
        for (int i = 0; i < 9; ++i) {
            this.filter.set(i, tag.m_128441_("filter" + i) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("filter" + i)) : ItemStack.f_41583_);
        }
        this.filterWhitelist = tag.m_128441_("filterWhitelist") && tag.m_128471_("filterWhitelist");
        this.filterDurability = tag.m_128441_("filterDurability") && tag.m_128471_("filterDurability");
        this.showArea = tag.m_128441_("showArea") && tag.m_128471_("showArea");
    }

    public AABB getRenderBoundingBox() {
        return this.getAffectedArea();
    }
}

