/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.immersiveengineering.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.immersiveengineering.recipe.IERecipeJS;
import dev.latvian.mods.kubejs.immersiveengineering.recipe.IERecipes;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentWithParent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public interface CrusherRecipeSchema {
    public static final RecipeComponent<OutputItem> SECONDARY_OUTPUT_COMPONENT = new RecipeComponentWithParent<OutputItem>(){

        public RecipeComponent<OutputItem> parentComponent() {
            return ItemComponents.OUTPUT;
        }

        public JsonElement write(RecipeJS recipe, OutputItem value) {
            JsonObject json = new JsonObject();
            json.add("output", super.write(recipe, (Object)value));
            if (value.hasChance()) {
                json.addProperty("chance", (Number)value.getChance());
            }
            return json;
        }

        public OutputItem read(RecipeJS recipe, Object from) {
            if (from instanceof JsonObject) {
                JsonObject json = (JsonObject)from;
                OutputItem output = OutputItem.EMPTY;
                if (CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (ICondition.IContext)ICondition.IContext.EMPTY)) {
                    output = (OutputItem)super.read(recipe, (Object)json.get("output"));
                    if (json.has("chance")) {
                        output = output.withChance(json.get("chance").getAsDouble());
                    }
                }
                return output;
            }
            return (OutputItem)super.read(recipe, from);
        }

        public String toString() {
            return this.parentComponent().toString();
        }
    };
    public static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
    public static final RecipeKey<InputItem> INPUT = ItemComponents.INPUT.key("input");
    public static final RecipeKey<OutputItem[]> SECONDARIES = SECONDARY_OUTPUT_COMPONENT.asArray().key("secondaries").defaultOptional();
    public static final RecipeKey<Integer> ENERGY = IERecipes.energy(6000);
    public static final RecipeSchema SCHEMA = new RecipeSchema(IERecipeJS.class, IERecipeJS::new, new RecipeKey[]{RESULT, INPUT, SECONDARIES, ENERGY});
}

