/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.immersiveengineering.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.immersiveengineering.recipe.IERecipeJS;
import dev.latvian.mods.kubejs.immersiveengineering.recipe.IERecipes;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentWithParent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import java.util.Map;

public interface SawmillRecipeSchema {
    public static final RecipeComponent<OutputItem> STRIPPING_OUTPUT_ITEM = new RecipeComponentWithParent<OutputItem>(){

        public RecipeComponent<OutputItem> parentComponent() {
            return ItemComponents.OUTPUT;
        }

        public boolean hasPriority(RecipeJS recipe, Object from) {
            JsonObject json;
            Map m;
            return from instanceof Map && (m = (Map)from).containsKey("output") && m.containsKey("stripping") || from instanceof JsonObject && (json = (JsonObject)from).has("output") && json.has("stripping");
        }

        public JsonElement write(RecipeJS recipe, OutputItem value) {
            if (value instanceof StrippingOutputItem) {
                JsonObject json = new JsonObject();
                json.add("item", ItemComponents.OUTPUT.write(recipe, (Object)value));
                json.addProperty("stripping", Boolean.valueOf(true));
                return json;
            }
            return ItemComponents.OUTPUT.write(recipe, (Object)value);
        }

        public OutputItem read(RecipeJS recipe, Object from) {
            JsonObject j;
            Map m;
            if (from instanceof Map && (m = (Map)from).containsKey("output") && m.containsKey("stripping")) {
                OutputItem item = (OutputItem)ItemComponents.OUTPUT.read(recipe, m.get("output"));
                return (Boolean)m.get("stripping") != false ? new StrippingOutputItem(item) : item;
            }
            if (from instanceof JsonObject && (j = (JsonObject)from).has("output") && j.has("stripping")) {
                OutputItem item = (OutputItem)ItemComponents.OUTPUT.read(recipe, (Object)j.get("output"));
                return j.get("stripping").getAsBoolean() ? new StrippingOutputItem(item) : item;
            }
            return (OutputItem)ItemComponents.OUTPUT.read(recipe, from);
        }
    };
    public static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
    public static final RecipeKey<InputItem> INPUT = ItemComponents.INPUT.key("input");
    public static final RecipeKey<Either<OutputItem, OutputItem>[]> SECONDARIES = STRIPPING_OUTPUT_ITEM.or(ItemComponents.OUTPUT).asArray().key("secondaries");
    public static final RecipeKey<OutputItem> STRIPPED = ItemComponents.OUTPUT.key("stripped").defaultOptional();
    public static final RecipeKey<Integer> ENERGY = IERecipes.energy(1600);
    public static final RecipeSchema SCHEMA = new RecipeSchema(IERecipeJS.class, IERecipeJS::new, new RecipeKey[]{RESULT, INPUT, SECONDARIES, STRIPPED, ENERGY});

    public static class StrippingOutputItem
    extends OutputItem {
        public StrippingOutputItem(OutputItem parent) {
            super(parent.item, parent.chance);
        }
    }
}

