/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.particles.fluidparticle;

import com.direwolf20.laserio.client.particles.ModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class FluidFlowParticleData
implements ParticleOptions {
    private final FluidStack fluidStack;
    public final double targetX;
    public final double targetY;
    public final double targetZ;
    public final int ticksPerBlock;
    public static final ParticleOptions.Deserializer<FluidFlowParticleData> DESERIALIZER = new ParticleOptions.Deserializer<FluidFlowParticleData>(){

        @Nonnull
        public FluidFlowParticleData fromCommand(ParticleType<FluidFlowParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            ItemParser.ItemResult itemparser$itemresult = ItemParser.m_235305_((HolderLookup)HolderLookup.m_235701_((Registry)Registry.f_122827_), (StringReader)reader);
            ItemStack itemstack = new ItemInput(itemparser$itemresult.f_235328_(), itemparser$itemresult.f_235329_()).m_120980_(1, false);
            reader.expect(' ');
            double tx = reader.readDouble();
            reader.expect(' ');
            double ty = reader.readDouble();
            reader.expect(' ');
            double tz = reader.readDouble();
            reader.expect(' ');
            int ticks = reader.readInt();
            return new FluidFlowParticleData(FluidStack.EMPTY, tx, ty, tz, ticks);
        }

        public FluidFlowParticleData fromNetwork(ParticleType<FluidFlowParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new FluidFlowParticleData(buffer.readFluidStack(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readInt());
        }
    };

    public FluidFlowParticleData(FluidStack fluidStack, double tx, double ty, double tz, int ticks) {
        this.fluidStack = fluidStack.copy();
        this.targetX = tx;
        this.targetY = ty;
        this.targetZ = tz;
        this.ticksPerBlock = ticks;
    }

    @Nonnull
    public ParticleType<FluidFlowParticleData> m_6012_() {
        return (ParticleType)ModParticles.FLUIDFLOWPARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFluidStack(this.fluidStack);
        buffer.writeDouble(this.targetX);
        buffer.writeDouble(this.targetY);
        buffer.writeDouble(this.targetZ);
        buffer.writeInt(this.ticksPerBlock);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %s", this.m_6012_(), this.targetX, this.targetY, this.targetZ, this.ticksPerBlock);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getFluidStack() {
        return this.fluidStack;
    }
}

