/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import team.lodestar.lodestone.systems.config.ConfigGroup;
import team.lodestar.lodestone.systems.config.ConfigValueHolder;
import team.lodestar.lodestone.systems.config.LodestoneConfig;

public class ClientConfig
extends LodestoneConfig {
    public static final ConfigGroup CLIENT = new ConfigGroup("lodestone", "client");
    public static ConfigValueHolder<Boolean> DELAYED_PARTICLE_RENDERING = new ConfigValueHolder(CLIENT, "graphics/particle", builder -> builder.comment("Should particles render on the delayed buffer? This means they will properly render after clouds & water do, but could cause issues with mods like sodium.").define("buffer_particles", true));
    public static ConfigValueHolder<Double> FIRE_OVERLAY_OFFSET = new ConfigValueHolder(CLIENT, "graphics/fire", builder -> builder.comment("Downwards offset of Minecraft's first-person fire overlay. Higher numbers cause it to visually display lower and free up more screen space.").defineInRange("fire_overlay_offset", 0.0, 0.0, 1.0));
    public static ConfigValueHolder<Double> SCREENSHAKE_INTENSITY = new ConfigValueHolder(CLIENT, "graphics/screenshake", builder -> builder.comment("Intensity of screenshake. Higher numbers increase amplitude. Disable to turn off screenshake.").defineInRange("screenshake_intensity", 1.0, 0.0, 5.0));
    public static ConfigValueHolder<Boolean> ENABLE_SCREEN_PARTICLES = new ConfigValueHolder(CLIENT, "graphics/screen_particles", builder -> builder.comment("Are screen particles enabled?").define("enable_screen_particles", true));
    public static final ClientConfig INSTANCE;
    public static final ForgeConfigSpec SPEC;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        super(CLIENT, builder);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (ClientConfig)specPair.getLeft();
    }
}

