/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;

public class LodestoneAttributeEventHandler {
    public static void processAttributes(LivingHurtEvent event) {
        Entity magicResistance;
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntity();
        if (source.m_19387_()) {
            LivingEntity attacker;
            AttributeInstance magicProficiency;
            float amount = event.getAmount();
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity && (magicProficiency = (attacker = (LivingEntity)entity).m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_PROFICIENCY.get())) != null && magicProficiency.m_22135_() > 0.0) {
                amount = (float)((double)amount + magicProficiency.m_22135_() * 0.5);
            }
            if ((magicResistance = target.m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_RESISTANCE.get())) != null && magicResistance.m_22135_() > 0.0) {
                amount = (float)((double)amount * LodestoneAttributeEventHandler.applyMagicResistance(magicResistance.m_22135_()));
            }
            event.setAmount(amount);
        }
        if ((magicResistance = source.m_7639_()) instanceof LivingEntity) {
            AttributeInstance magicDamage;
            LivingEntity attacker = (LivingEntity)magicResistance;
            if (!source.m_19387_() && (magicDamage = attacker.m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get())) != null && magicDamage.m_22135_() > 0.0 && target.m_6084_()) {
                target.f_19802_ = 0;
                target.m_6469_(new EntityDamageSource(DamageSource.f_19319_.m_19385_(), (Entity)attacker).m_19389_(), (float)magicDamage.m_22135_());
            }
        }
    }

    public static double applyMagicResistance(double magicResistance) {
        return (1.0 - 0.75 * (1.0 / (0.2 * (magicResistance + 1.0)))) * 0.8;
    }
}

