/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers.screenparticle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.particle.screen.LodestoneScreenParticleRenderType;
import team.lodestar.lodestone.systems.particle.screen.base.ScreenParticle;

public class ParticleEmitterHandler {
    public static final Map<Item, ItemParticleSupplier> EMITTERS = new HashMap<Item, ItemParticleSupplier>();

    public static void registerParticleEmitters(FMLClientSetupEvent event) {
        DataHelper.takeAll(new ArrayList(ForgeRegistries.ITEMS.getValues()), i -> i instanceof ItemParticleSupplier).forEach(i -> {
            ItemParticleSupplier emitter = (ItemParticleSupplier)i;
            ParticleEmitterHandler.registerItemParticleEmitter(i, emitter);
        });
    }

    public static void registerItemParticleEmitter(Item item, ItemParticleSupplier emitter) {
        EMITTERS.put(item, emitter);
    }

    public static void registerItemParticleEmitter(ItemParticleSupplier emitter, Item ... items) {
        for (Item item : items) {
            EMITTERS.put(item, emitter);
        }
    }

    public static interface ItemParticleSupplier {
        public void spawnParticles(HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> var1, Level var2, float var3, ItemStack var4, float var5, float var6);
    }
}

