/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DataHelper {
    public static <T, K extends Collection<T>> K reverseOrder(K reversed, Collection<T> items) {
        ArrayList<T> original = new ArrayList<T>(items);
        for (int i = items.size() - 1; i >= 0; --i) {
            reversed.add(original.get(i));
        }
        return reversed;
    }

    public static String toTitleCase(String givenString, String regex) {
        String[] stringArray = givenString.split(regex);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0))).append(string.substring(1)).append(regex);
        }
        return stringBuilder.toString().trim().replaceAll(regex, " ").substring(0, stringBuilder.length() - 1);
    }

    public static int[] nextInts(int count, int range) {
        RandomSource rand = RandomSource.m_216327_();
        int[] ints = new int[count];
        for (int i = 0; i < count; ++i) {
            int nextInt;
            do {
                nextInt = rand.m_188503_(range);
            } while (!Arrays.stream(ints).noneMatch(j -> j == nextInt));
            ints[i] = nextInt;
        }
        return ints;
    }

    public static <T> boolean hasDuplicate(T[] things) {
        HashSet thingSet = new HashSet();
        return !Arrays.stream(things).allMatch(thingSet::add);
    }

    public static <T> T take(Collection<? extends T> src, T item) {
        src.remove(item);
        return item;
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Collection<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            return Collections.emptyList();
        }
        if (!src.removeAll(ret)) {
            return Collections.emptyList();
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Collection<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            return Collections.emptyList();
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Collection<T> getAll(Collection<? extends T> src, T ... items) {
        return List.copyOf(DataHelper.getAll(src, t -> Arrays.stream(items).anyMatch(tAgain -> tAgain.getClass().isInstance(t))));
    }

    public static <T> Collection<T> getAll(Collection<T> src, Predicate<T> pred) {
        return src.stream().filter(pred).collect(Collectors.toList());
    }

    public static Vec3 radialOffset(Vec3 pos, float distance, float current, float total) {
        double angle = (double)(current / total) * (Math.PI * 2);
        double dx2 = (double)distance * Math.cos(angle);
        double dz2 = (double)distance * Math.sin(angle);
        Vec3 vector = new Vec3(dx2, 0.0, dz2);
        double x = vector.f_82479_ * (double)distance;
        double z = vector.f_82481_ * (double)distance;
        return pos.m_82549_(new Vec3(x, 0.0, z));
    }

    public static ArrayList<Vec3> rotatingRadialOffsets(Vec3 pos, float distance, float total, long gameTime, float time) {
        return DataHelper.rotatingRadialOffsets(pos, distance, distance, total, gameTime, time);
    }

    public static ArrayList<Vec3> rotatingRadialOffsets(Vec3 pos, float distanceX, float distanceZ, float total, long gameTime, float time) {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        int i = 0;
        while ((float)i <= total) {
            positions.add(DataHelper.rotatingRadialOffset(pos, distanceX, distanceZ, i, total, gameTime, time));
            ++i;
        }
        return positions;
    }

    public static Vec3 rotatingRadialOffset(Vec3 pos, float distance, float current, float total, long gameTime, float time) {
        return DataHelper.rotatingRadialOffset(pos, distance, distance, current, total, gameTime, time);
    }

    public static Vec3 rotatingRadialOffset(Vec3 pos, float distanceX, float distanceZ, float current, float total, long gameTime, float time) {
        double angle = (double)(current / total) * (Math.PI * 2);
        double dx2 = (double)distanceX * Math.cos(angle += (double)((float)gameTime % time / time) * (Math.PI * 2));
        double dz2 = (double)distanceZ * Math.sin(angle);
        Vec3 vector2f = new Vec3(dx2, 0.0, dz2);
        double x = vector2f.f_82479_ * (double)distanceX;
        double z = vector2f.f_82481_ * (double)distanceZ;
        return pos.m_82520_(x, 0.0, z);
    }

    public static ArrayList<Vec3> blockOutlinePositions(Level level, BlockPos pos) {
        ArrayList<Vec3> arrayList = new ArrayList<Vec3>();
        double d0 = 0.5625;
        RandomSource random = level.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.m_121945_(direction);
            if (level.m_8055_(blockpos).m_60804_((BlockGetter)level, blockpos)) continue;
            Direction.Axis direction$axis = direction.m_122434_();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : (double)random.m_188501_();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : (double)random.m_188501_();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : (double)random.m_188501_();
            arrayList.add(new Vec3((double)pos.m_123341_() + d1, (double)pos.m_123342_() + d2, (double)pos.m_123343_() + d3));
        }
        return arrayList;
    }

    public static float distSqr(float ... a) {
        float d = 0.0f;
        for (float f : a) {
            d += f * f;
        }
        return d;
    }

    public static float distance(float ... a) {
        return Mth.m_14116_((float)DataHelper.distSqr(a));
    }
}

