/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.mixin;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Unique
    private AttributeModifier attributeModifier;

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;getId()Ljava/util/UUID;", ordinal=0), index=13)
    private AttributeModifier getTooltip(AttributeModifier value) {
        this.attributeModifier = value;
        return value;
    }

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;getOperation()Lnet/minecraft/world/entity/ai/attributes/AttributeModifier$Operation;", ordinal=0), index=16)
    private boolean getTooltip(boolean value, @Nullable Player player, TooltipFlag flag) {
        if (player != null && this.attributeModifier.m_22209_().equals(LodestoneAttributeRegistry.UUIDS.get(LodestoneAttributeRegistry.MAGIC_DAMAGE))) {
            return true;
        }
        return value;
    }

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="STORE"))
    private Multimap<Attribute, AttributeModifier> getTooltip(Multimap<Attribute, AttributeModifier> map, @Nullable Player player, TooltipFlag flag) {
        if (player != null) {
            LinkedHashMultimap copied = LinkedHashMultimap.create();
            for (Map.Entry entry : map.entries()) {
                Attribute key = (Attribute)entry.getKey();
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                double amount = modifier.m_22218_();
                if (modifier.m_22209_().equals(LodestoneAttributeRegistry.UUIDS.get(LodestoneAttributeRegistry.MAGIC_DAMAGE))) {
                    AttributeInstance instance = player.m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_PROFICIENCY.get());
                    if (instance != null && instance.m_22135_() > 0.0) {
                        amount += instance.m_22135_() * 0.5;
                    }
                    copied.put((Object)key, (Object)new AttributeModifier(modifier.m_22209_(), modifier.m_22214_(), amount, modifier.m_22217_()));
                    continue;
                }
                copied.put((Object)key, (Object)modifier);
            }
            return copied;
        }
        return map;
    }
}

