/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.lodestar.lodestone.systems.postprocess.PostProcessHandler;
import team.lodestar.lodestone.systems.sound.ExtendedSoundType;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Unique
    private SoundType type;

    @ModifyVariable(method={"levelEvent"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;stateById(I)Lnet/minecraft/world/level/block/state/BlockState;")), at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/SoundType;getBreakSound()Lnet/minecraft/sounds/SoundEvent;"))
    private SoundType lodestoneGetBreakSound(SoundType type) {
        this.type = type;
        return this.type;
    }

    @Inject(method={"levelEvent"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;stateById(I)Lnet/minecraft/world/level/block/state/BlockState;"))}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;playLocalSound(Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZ)V", ordinal=0)})
    private void lodestoneCallExtendedBreakSound(int pType, BlockPos pPos, int pData, CallbackInfo ci) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        SoundType soundType = this.type;
        if (soundType instanceof ExtendedSoundType) {
            ExtendedSoundType extendedSoundType = (ExtendedSoundType)soundType;
            extendedSoundType.onPlayBreakSound((Level)level, pPos);
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="net.minecraft.client.renderer.PostChain.process(F)V", ordinal=1)})
    public void injectionBeforeTransparencyChainProcess(CallbackInfo ci) {
        PostProcessHandler.copyDepthBuffer();
    }
}

