/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.registry.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;
import team.lodestar.lodestone.systems.rendering.shader.ShaderHolder;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="lodestone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LodestoneShaderRegistry {
    public static ShaderHolder LODESTONE_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("lodestone_texture"), DefaultVertexFormat.f_85820_, "LumiTransparency");
    public static ShaderHolder PARTICLE = new ShaderHolder(LodestoneLib.lodestonePath("particle/particle"), DefaultVertexFormat.f_85813_, "LumiTransparency");
    public static ShaderHolder SCREEN_PARTICLE = new ShaderHolder(LodestoneLib.lodestonePath("screen/screen_particle"), DefaultVertexFormat.f_85819_, new String[0]);
    public static ShaderHolder DISTORTED_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("screen/distorted_texture"), DefaultVertexFormat.f_85818_, "Speed", "TimeOffset", "Intensity", "XFrequency", "YFrequency", "UVCoordinates");
    public static ShaderHolder SCROLLING_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("shapes/scrolling_texture"), DefaultVertexFormat.f_85820_, "Speed", "LumiTransparency");
    public static ShaderHolder TRIANGLE_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("shapes/triangle_texture"), DefaultVertexFormat.f_85820_, "LumiTransparency");
    public static ShaderHolder SCROLLING_TRIANGLE_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("shapes/scrolling_triangle_texture"), DefaultVertexFormat.f_85820_, "Speed", "LumiTransparency");

    @SubscribeEvent
    public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
        ResourceManager resourceManager = event.getResourceManager();
        LodestoneShaderRegistry.registerShader(event, LODESTONE_TEXTURE.createInstance(resourceManager));
        LodestoneShaderRegistry.registerShader(event, PARTICLE.createInstance(resourceManager));
        LodestoneShaderRegistry.registerShader(event, SCREEN_PARTICLE.createInstance(resourceManager));
        LodestoneShaderRegistry.registerShader(event, DISTORTED_TEXTURE.createInstance(resourceManager));
        LodestoneShaderRegistry.registerShader(event, SCROLLING_TEXTURE.createInstance(resourceManager));
        LodestoneShaderRegistry.registerShader(event, TRIANGLE_TEXTURE.createInstance(resourceManager));
        LodestoneShaderRegistry.registerShader(event, SCROLLING_TRIANGLE_TEXTURE.createInstance(resourceManager));
    }

    public static void registerShader(RegisterShadersEvent event, ExtendedShaderInstance extendedShaderInstance) {
        event.registerShader((ShaderInstance)extendedShaderInstance, (T s) -> {});
    }
}

