/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.common.ForgeConfigSpec;
import team.lodestar.lodestone.systems.config.ConfigGroup;
import team.lodestar.lodestone.systems.config.ConfigValueHolder;

public class LodestoneConfig {
    public static final ConcurrentHashMap<ConfigGroup, HashMap<String, ArrayList<ConfigValueHolder>>> VALUE_HOLDERS = new ConcurrentHashMap();

    public LodestoneConfig(ConfigGroup configGroup, ForgeConfigSpec.Builder builder) {
        HashMap<String, ArrayList<ConfigValueHolder>> map = VALUE_HOLDERS.get(configGroup);
        for (Map.Entry<String, ArrayList<ConfigValueHolder>> valueHolder : map.entrySet()) {
            List<String> path = List.of(valueHolder.getKey().split("/"));
            builder.push(path);
            ArrayList<ConfigValueHolder> h = valueHolder.getValue();
            for (ConfigValueHolder configValueHolder : h) {
                configValueHolder.setConfig(builder);
            }
            builder.pop(path.size());
        }
    }

    public static HashMap<String, ArrayList<ConfigValueHolder>> getConfigEntries(ConfigGroup configGroup) {
        return VALUE_HOLDERS.computeIfAbsent(configGroup, c -> new HashMap());
    }

    public static interface BuilderSupplier<T> {
        public ForgeConfigSpec.ConfigValue<T> createBuilder(ForgeConfigSpec.Builder var1);
    }
}

