/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.fireeffect;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;
import team.lodestar.lodestone.capability.LodestoneEntityDataCapability;
import team.lodestar.lodestone.registry.common.LodestoneFireEffectRegistry;
import team.lodestar.lodestone.systems.fireeffect.FireEffectType;

public class FireEffectInstance {
    public int duration;
    public final FireEffectType type;

    public FireEffectInstance(FireEffectType type) {
        this.type = type;
    }

    public FireEffectInstance extendDuration(int increase) {
        this.duration += increase;
        return this;
    }

    public FireEffectInstance setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public FireEffectInstance sync(Entity target) {
        LodestoneEntityDataCapability.syncData(target, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target), "fireEffect");
        return this;
    }

    public void tick(Entity target) {
        if (target.f_146808_ || target.m_20071_()) {
            this.type.extinguish(this, target);
        }
        if (this.canDamageTarget(target)) {
            --this.duration;
            if (this.type.isValid(this) && this.duration % this.type.getTickInterval(this) == 0) {
                this.type.tick(this, target);
            }
        } else {
            this.duration -= 4;
        }
    }

    public void entityAttack() {
    }

    public boolean canDamageTarget(Entity target) {
        return !target.m_5825_();
    }

    public boolean isValid() {
        return this.type.isValid(this);
    }

    public void serializeNBT(CompoundTag tag) {
        CompoundTag fireTag = new CompoundTag();
        fireTag.m_128359_("type", this.type.id);
        fireTag.m_128405_("duration", this.duration);
        tag.m_128365_("fireEffect", (Tag)fireTag);
    }

    public static FireEffectInstance deserializeNBT(CompoundTag tag) {
        if (!tag.m_128441_("fireEffect")) {
            return null;
        }
        CompoundTag fireTag = tag.m_128469_("fireEffect");
        FireEffectInstance instance = new FireEffectInstance(LodestoneFireEffectRegistry.FIRE_TYPES.get(fireTag.m_128461_("type")));
        instance.setDuration(fireTag.m_128451_("duration"));
        return instance;
    }
}

