/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.util.RandomSource;
import team.lodestar.lodestone.handlers.screenparticle.ScreenParticleHandler;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.data.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.SpinParticleData;
import team.lodestar.lodestone.systems.particle.screen.GenericScreenParticle;
import team.lodestar.lodestone.systems.particle.screen.LodestoneScreenParticleRenderType;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleOptions;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;
import team.lodestar.lodestone.systems.particle.screen.base.ScreenParticle;

public class ScreenParticleBuilder {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    final ScreenParticleType<?> type;
    final ScreenParticleOptions options;
    final HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> target;
    double xMotion = 0.0;
    double yMotion = 0.0;
    double maxXSpeed = 0.0;
    double maxYSpeed = 0.0;
    double maxXOffset = 0.0;
    double maxYOffset = 0.0;

    public static ScreenParticleBuilder create(ScreenParticleType<?> type, HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> target) {
        return new ScreenParticleBuilder(type, target);
    }

    protected ScreenParticleBuilder(ScreenParticleType<?> type, HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> target) {
        this.type = type;
        this.options = new ScreenParticleOptions(type);
        this.target = target;
    }

    public ScreenParticleBuilder setColorData(ColorParticleData colorData) {
        this.options.colorData = colorData;
        return this;
    }

    public ScreenParticleBuilder setScaleData(GenericParticleData scaleData) {
        this.options.scaleData = scaleData;
        return this;
    }

    public ScreenParticleBuilder setTransparencyData(GenericParticleData transparencyData) {
        this.options.transparencyData = transparencyData;
        return this;
    }

    public ScreenParticleBuilder setSpinData(SpinParticleData spinData) {
        this.options.spinData = spinData;
        return this;
    }

    public ScreenParticleBuilder setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType discardFunctionType) {
        this.options.discardFunctionType = discardFunctionType;
        return this;
    }

    public ScreenParticleBuilder setSpritePicker(SimpleParticleOptions.ParticleSpritePicker spritePicker) {
        this.options.spritePicker = spritePicker;
        return this;
    }

    public ScreenParticleBuilder setRenderType(LodestoneScreenParticleRenderType renderType) {
        this.options.renderType = renderType;
        return this;
    }

    public ScreenParticleBuilder setLifetime(int lifetime) {
        this.options.lifetime = lifetime;
        return this;
    }

    public ScreenParticleBuilder setGravity(float gravity) {
        this.options.gravity = gravity;
        return this;
    }

    public ScreenParticleBuilder setRandomMotion(double maxSpeed) {
        return this.setRandomMotion(maxSpeed, maxSpeed);
    }

    public ScreenParticleBuilder setRandomMotion(double maxXSpeed, double maxYSpeed) {
        this.maxXSpeed = maxXSpeed;
        this.maxYSpeed = maxYSpeed;
        return this;
    }

    public ScreenParticleBuilder addMotion(double vx, double vy) {
        this.xMotion += vx;
        this.yMotion += vy;
        return this;
    }

    public ScreenParticleBuilder setMotion(double vx, double vy) {
        this.xMotion = vx;
        this.yMotion = vy;
        return this;
    }

    public ScreenParticleBuilder setRandomOffset(double maxDistance) {
        return this.setRandomOffset(maxDistance, maxDistance);
    }

    public ScreenParticleBuilder setRandomOffset(double maxXDist, double maxYDist) {
        this.maxXOffset = maxXDist;
        this.maxYOffset = maxYDist;
        return this;
    }

    public ScreenParticleBuilder act(Consumer<ScreenParticleBuilder> particleBuilderConsumer) {
        particleBuilderConsumer.accept(this);
        return this;
    }

    public ScreenParticleBuilder addActor(Consumer<GenericScreenParticle> particleActor) {
        this.options.actor = particleActor;
        return this;
    }

    public ScreenParticleBuilder spawn(double x, double y) {
        double yaw = (double)RANDOM.m_188501_() * Math.PI * 2.0;
        double pitch = (double)RANDOM.m_188501_() * Math.PI - 1.5707963267948966;
        double xSpeed = (double)RANDOM.m_188501_() * this.maxXSpeed;
        double ySpeed = (double)RANDOM.m_188501_() * this.maxYSpeed;
        this.xMotion += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
        this.yMotion += Math.sin(pitch) * ySpeed;
        double yaw2 = (double)RANDOM.m_188501_() * Math.PI * 2.0;
        double pitch2 = (double)RANDOM.m_188501_() * Math.PI - 1.5707963267948966;
        double xDist = (double)RANDOM.m_188501_() * this.maxXOffset;
        double yDist = (double)RANDOM.m_188501_() * this.maxYOffset;
        double xPos = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
        double yPos = Math.sin(pitch2) * yDist;
        ScreenParticleHandler.addParticle(this.target, this.options, x + xPos, y + yPos, this.xMotion, this.yMotion);
        return this;
    }

    public ScreenParticleBuilder repeat(double x, double y, int n) {
        for (int i = 0; i < n; ++i) {
            this.spawn(x, y);
        }
        return this;
    }

    public ScreenParticleBuilder spawnOnStack(double xOffset, double yOffset) {
        this.options.tracksStack = true;
        this.options.stackTrackXOffset = xOffset;
        this.options.stackTrackYOffset = yOffset;
        this.spawn((double)ScreenParticleHandler.currentItemX + xOffset, (double)ScreenParticleHandler.currentItemY + yOffset);
        return this;
    }

    public ScreenParticleBuilder repeatOnStack(double xOffset, double yOffset, int n) {
        for (int i = 0; i < n; ++i) {
            this.spawn(xOffset, yOffset);
        }
        return this;
    }
}

